/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.security.MultiAuthPlugin;
import org.apache.solr.security.RuleBasedAuthorizationPluginBase;

public class MultiAuthRuleBasedAuthorizationPlugin
extends RuleBasedAuthorizationPluginBase {
    private final Map<String, RuleBasedAuthorizationPluginBase> pluginMap = new LinkedHashMap<String, RuleBasedAuthorizationPluginBase>();
    private final SolrResourceLoader loader;

    public MultiAuthRuleBasedAuthorizationPlugin(CoreContainer cc) {
        this.loader = cc.getResourceLoader();
    }

    @Override
    public void init(Map<String, Object> initInfo) {
        super.init(initInfo);
        Object o = initInfo.get("schemes");
        if (!(o instanceof List)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid config: " + this.getClass().getName() + " requires a list of schemes!");
        }
        List schemeList = (List)o;
        if (schemeList.size() < 2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid config: " + this.getClass().getName() + " requires at least two schemes!");
        }
        for (Object s : schemeList) {
            if (!(s instanceof Map)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid scheme config, expected JSON object but found: " + s);
            }
            this.initPluginForScheme((Map)s);
        }
    }

    protected void initPluginForScheme(Map<String, Object> schemeMap) {
        HashMap<String, Object> schemeConfig = new HashMap<String, Object>(schemeMap);
        String scheme = (String)schemeConfig.remove("scheme");
        if (StringUtils.isEmpty((String)scheme)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'scheme' is a required attribute: " + schemeMap);
        }
        String clazz = (String)schemeConfig.remove("class");
        if (StringUtils.isEmpty((String)clazz)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'class' is a required attribute: " + schemeMap);
        }
        RuleBasedAuthorizationPluginBase pluginForScheme = this.loader.newInstance(clazz, RuleBasedAuthorizationPluginBase.class);
        pluginForScheme.init(schemeConfig);
        this.pluginMap.put(scheme.toLowerCase(Locale.ROOT), pluginForScheme);
    }

    @Override
    public Set<String> getUserRoles(Principal principal) {
        HashSet<String> mergedRoles = new HashSet<String>();
        for (RuleBasedAuthorizationPluginBase plugin : this.pluginMap.values()) {
            Set<String> userRoles = plugin.getUserRoles(principal);
            if (userRoles == null) continue;
            mergedRoles.addAll(userRoles);
        }
        return mergedRoles;
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        boolean madeChanges = false;
        for (CommandOperation c : commands) {
            if (c.name.endsWith("-permission")) {
                Map<String, Object> updated = super.edit(latestConf, Collections.singletonList(c));
                if (updated == null) continue;
                madeChanges = true;
                latestConf = updated;
                continue;
            }
            Map dataMap = c.getDataMap();
            if (dataMap == null || dataMap.size() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "All edit commands must include a 'scheme' wrapper object!");
            }
            String scheme = ((String)dataMap.keySet().iterator().next()).toLowerCase(Locale.ROOT);
            RuleBasedAuthorizationPluginBase plugin = this.pluginMap.get(scheme);
            if (plugin == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No authorization plugin configured for the '" + scheme + "' scheme! Did you forget to wrap the command with a scheme object?");
            }
            CommandOperation cmdForPlugin = new CommandOperation(c.name, dataMap.get(scheme));
            if (MultiAuthPlugin.applyEditCommandToSchemePlugin(scheme, plugin, cmdForPlugin, latestConf)) {
                madeChanges = true;
            }
            for (String err : cmdForPlugin.getErrors()) {
                c.addError(err);
            }
        }
        return madeChanges ? latestConf : null;
    }
}

