/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.profile.api.controller.internal;

import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.person.business.RegistrationService;
import de.justsoftware.onx.person.business.model.RegistrationModel;
import de.justsoftware.onx.person.business.model.RegistrationValidationException;
import de.justsoftware.profile.api.controller.internal.model.InternalCreateProfileModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/rest/internal/profile"})
@Api(tags={"Profile"})
public class InternalProfileController {
    private final RegistrationService _registrationService;

    @Autowired
    public InternalProfileController(RegistrationService registrationService) {
        this._registrationService = registrationService;
    }

    @Nonnull
    @RequestMapping(value={"/createprofile"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Creates a new, activated profile (unless the email is already taken).", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - creates profile and returns its id"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ProfileId createNewProfile(@RequestBody InternalCreateProfileModel profileModel) throws RegistrationValidationException {
        RegistrationModel registrationModel = profileModel.toRegistrationModel();
        return this._registrationService.createProfileWithoutAuthCheck(registrationModel);
    }
}

