/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.profile.api.controller;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.RegistrationService;
import de.justsoftware.onx.person.shared.model.NameSettings;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.model.Profile;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfilePersonalData;
import de.justsoftware.onx.profile.model.ProfileSection;
import de.justsoftware.onx.profile.model.ProfileValidationException;
import de.justsoftware.profile.api.exception.ResourceNotFoundException;
import de.justsoftware.profile.api.model.Birthday;
import de.justsoftware.profile.api.model.ProfileAttributes;
import de.justsoftware.profile.api.model.ProfileName;
import de.justsoftware.profile.api.model.ProfileRoles;
import de.justsoftware.profile.api.model.ProfileSettings;
import de.justsoftware.toolbox.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/profile/api/v1"})
@Api(tags={"Profile"})
public class ProfileController {
    private static final String PROFILE_EDIT_ROLES = "PROFILE_EDIT_ROLES";
    private static final String PROFILE_EDIT_HEADER_FIELDS = "PROFILE_EDIT_HEADER_FIELDS";
    private static final ImmutableSet<String> EDITABLE_HEADER_FIELDS = ImmutableSet.of((Object)"person.title", (Object)"person.firstname", (Object)"person.lastname", (Object)"person.additionalTitle");
    private final RegistrationService _registrationService;
    private final ProfileService _profileService;
    private final PersonService _personService;
    private final Settings _settings;

    @Autowired
    public ProfileController(ProfileService profileService, RegistrationService registrationService, PersonService personService, Settings settings) {
        this._profileService = profileService;
        this._registrationService = registrationService;
        this._personService = personService;
        this._settings = settings;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, path={"/{profileId}"}, produces={"application/json"})
    @ApiOperation(value="get data of one profile", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns profile data"), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid id"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.Profile getProfileData(@PathVariable(value="profileId") ProfileId profileId, @AuthorizedContext AuthorizationContext authContext) throws ResourceNotFoundException {
        Profile profile = this._profileService.getProfileById(profileId, (AuthorizationCheckContextWithUserId)authContext);
        if (profile == null) {
            throw new ResourceNotFoundException("Profile with ID " + profileId.toString() + " not found.");
        }
        FluentIterable allowedActionsIter = FluentIterable.from((Iterable)profile.getAllowedActions()).transform(Action.TO_NAME);
        if (profile.isEditRolesAllowed()) {
            allowedActionsIter = allowedActionsIter.append((Object[])new String[]{PROFILE_EDIT_ROLES});
        }
        if (!this._settings.getHiddenPersonFields().containsAll(EDITABLE_HEADER_FIELDS)) {
            allowedActionsIter = allowedActionsIter.append((Object[])new String[]{PROFILE_EDIT_HEADER_FIELDS});
        }
        ImmutableSet allowedActions = allowedActionsIter.toSet();
        ImmutableSet roles = FluentIterable.from((Iterable)profile.getRoles()).transform(Role.TO_NAME).toSet();
        return new de.justsoftware.profile.api.model.Profile(profile.getId(), profile.getFullName(), profile.getTitle(), profile.getFirstName(), profile.getLastName(), profile.getAdditionalTitle(), profile.getImageUrl(), (ImmutableSet<String>)roles, profile.isActive(), profile.isBlocked(), profile.isDeleted(), profile.isVisible(), (ImmutableSet<String>)allowedActions, ProfileAttributes.FROM_BUSINESS_MODEL.apply(profile.getProfileAttributes()), profile.isUsesDefaultImage(), (Birthday)Birthday.FROM_BUSINESS_MODEL.apply((Object)profile.getBirthday()), profile.getBirthdayVisibility(), profile.getTimezone(), profile.isAcceptedProfileImageLegalTerms());
    }

    @CheckForNull
    @RequestMapping(method={RequestMethod.GET}, path={"/{profileId}/attributes/{sectionName}"}, produces={"application/json"})
    @ApiOperation(value="Return the section with the given name", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns the section of the given profile"), @ApiResponse(code=400, message="error - invalid profileId, sectionName"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.ProfileSection getProfileSection(@PathVariable(value="profileId") ProfileId profileId, @PathVariable(value="sectionName") String sectionName, @AuthorizedContext AuthorizationContext authContext) throws ResourceNotFoundException {
        ProfileSection profileSection = this._profileService.getProfileSection(profileId, sectionName, (AuthorizationCheckContextWithUserId)authContext);
        if (profileSection == null) {
            throw new ResourceNotFoundException("Section '" + sectionName + "' not found.");
        }
        return de.justsoftware.profile.api.model.ProfileSection.FROM_BUSINESS_MODEL.apply(profileSection);
    }

    @CheckForNull
    @RequestMapping(method={RequestMethod.POST}, path={"/{profileId}/attributes/{sectionName}"}, produces={"application/json"})
    @ApiOperation(value="create a profile section attribute block for the given profile into the given section", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns created profile attribute block of the section"), @ApiResponse(code=400, message="error - invalid profileId, sectionName or profile attribute block"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.ProfileAttributeBlock createProfileAttributeBlock(@PathVariable(value="profileId") ProfileId profileId, @PathVariable(value="sectionName") String sectionName, @RequestBody de.justsoftware.profile.api.model.ProfileAttributeBlock block, @AuthorizedContext AuthorizationContext authContext) throws ResourceNotFoundException, ProfileValidationException {
        if (block == null) {
            throw new IllegalArgumentException("Profile attribute block required!");
        }
        if (block.getOrderIndex() != null) {
            throw new IllegalArgumentException("Only profile attribute block without existing order index can be created!");
        }
        return de.justsoftware.profile.api.model.ProfileAttributeBlock.FROM_BUSINESS_MODEL.apply(this._profileService.saveProfileAttributeBlock(profileId, sectionName, (ProfileAttributeBlock)ObjectUtil.checkNotNull((Object)de.justsoftware.profile.api.model.ProfileAttributeBlock.TO_BUSINESS_MODEL.apply(block)), (AuthorizationCheckContext)authContext));
    }

    @CheckForNull
    @RequestMapping(method={RequestMethod.PUT}, path={"/{profileId}/attributes/{sectionName}"}, produces={"application/json"})
    @ApiOperation(value="update a profile section attribute block for the given profile into the given section", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns created profile attribute block of the section"), @ApiResponse(code=400, message="error - invalid profileId, sectionName or profile attribute block"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.ProfileAttributeBlock updateProfileAttributeBlock(@PathVariable(value="profileId") ProfileId profileId, @PathVariable(value="sectionName") String sectionName, @RequestBody de.justsoftware.profile.api.model.ProfileAttributeBlock block, @AuthorizedContext AuthorizationContext authContext) throws ResourceNotFoundException, ProfileValidationException {
        if (block == null) {
            throw new IllegalArgumentException("Profile attribute block required!");
        }
        if (block.getOrderIndex() == null) {
            throw new IllegalArgumentException("Only profile attribute block with existing order index can be updated!");
        }
        return de.justsoftware.profile.api.model.ProfileAttributeBlock.FROM_BUSINESS_MODEL.apply(this._profileService.saveProfileAttributeBlock(profileId, sectionName, (ProfileAttributeBlock)ObjectUtil.checkNotNull((Object)de.justsoftware.profile.api.model.ProfileAttributeBlock.TO_BUSINESS_MODEL.apply(block)), (AuthorizationCheckContext)authContext));
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/{profileId}/attributes/{sectionName}/{blockOrderIndex}"}, produces={"application/json"})
    @ApiOperation(value="delete a profile section attribute block for the given profile. Only visible attributes for the current user will be delete.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - status code = 200"), @ApiResponse(code=400, message="error - invalid profileId or sectionName"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public void deleteProfileAttributeBlock(@PathVariable(value="profileId") ProfileId profileId, @PathVariable(value="sectionName") String sectionName, @PathVariable(value="blockOrderIndex") int blockOrderIndex, @AuthorizedContext AuthorizationContext authContext) {
        this._profileService.deleteVisibleAndWritableProfileBlockAttributes(profileId, sectionName, blockOrderIndex, authContext);
    }

    @Nonnull
    @RequestMapping(value={"/{profileId}/image"}, method={RequestMethod.POST}, headers={"content-type=multipart/*"}, produces={"application/json"})
    @ApiOperation(value="Save the given profile image for the specified profile.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns updated profile."), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid profileId or invalid image file"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.Profile uploadProfileImage(@PathVariable(value="profileId") ProfileId profileId, @RequestParam(required=true, value="image") MultipartFile image, @AuthorizedContext AuthorizationContext authContext) {
        try {
            this._profileService.saveProfileImage(profileId, image, (AuthorizationCheckContext)authContext);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to save the profile image", (Throwable)e);
        }
        return this.getProfileData(profileId, authContext);
    }

    @Nonnull
    @RequestMapping(value={"/{profileId}/image"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ApiOperation(value="Delete the profile image for the specified profile.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns updated profile"), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid profileId"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.Profile deleteProfileImage(@PathVariable(value="profileId") ProfileId profileId, @AuthorizedContext AuthorizationContext authContext) {
        try {
            this._profileService.deleteProfileImage(profileId, (AuthorizationCheckContext)authContext);
        }
        catch (ValidatableException | IOException e) {
            throw new ServiceException("Failed to delete the profile image", e);
        }
        return this.getProfileData(profileId, authContext);
    }

    @Nonnull
    @RequestMapping(value={"/{profileId}/roles"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ApiOperation(value="Updates the roles for the specified profile.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns updated profile."), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid profileId"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.Profile updateProfileRoles(@PathVariable(value="profileId") ProfileId profileId, @RequestBody ProfileRoles profileRoles, @AuthorizedContext AuthorizationContext authContext) {
        this._profileService.savePersonRoles(profileId, (Set)profileRoles.getRoles().stream().map(PersonRole::valueOf).collect(ImmutableSet.toImmutableSet()), (AuthorizationCheckContext)authContext);
        return this.getProfileData(profileId, authContext);
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.PUT}, path={"/{profileId}/name"}, produces={"application/json"})
    @ApiOperation(value="update title and name of a profile", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns updated profile"), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid id"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.Profile updateProfileName(@PathVariable(value="profileId") ProfileId profileId, final @RequestBody ProfileName profile, @AuthorizedContext AuthorizationContext authContext) throws ResourceNotFoundException, ValidatableException {
        this._profileService.updateProfileNameSettings(profileId, new NameSettings(){

            public String getLastName() {
                return profile.getLastname();
            }

            public String getTitle() {
                return profile.getTitle();
            }

            public String getFirstName() {
                return profile.getFirstname();
            }

            public String getAdditionalTitle() {
                return profile.getAdditionalTitle();
            }
        }, (SearchAuthorizationCheckContext)authContext);
        return this.getProfileData(profileId, authContext);
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, path={"/settings"}, produces={"application/json"})
    @ApiOperation(value="retrieve profile related settings", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns settings"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ProfileSettings getProfileSettings() throws ResourceNotFoundException, ValidatableException {
        return new ProfileSettings(this._settings.isProfileImageLegalAgreementRequired());
    }

    @CheckForNull
    @RequestMapping(value={"/{profileId}/personal"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get the personal data of the given person. Need permission to edit the profile to read this data.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns updated profile."), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid profileId"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.ProfilePersonalData getProfilePersonalData(@PathVariable(value="profileId") ProfileId profileId, @AuthorizedContext AuthorizationContext authContext) {
        return de.justsoftware.profile.api.model.ProfilePersonalData.FROM_BUSINESS_MODEL.apply(this._profileService.getProfilePersonalData(profileId, authContext));
    }

    @CheckForNull
    @RequestMapping(value={"/{profileId}/personal"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ApiOperation(value="Get the personal data of the given person. Need permission to edit the profile to read this data.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns updated profile."), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid profileId"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public de.justsoftware.profile.api.model.ProfilePersonalData saveProfilePersonalData(@PathVariable(value="profileId") ProfileId profileId, @RequestBody de.justsoftware.profile.api.model.ProfilePersonalData profilePersonal, @AuthorizedContext AuthorizationContext authContext) {
        try {
            return de.justsoftware.profile.api.model.ProfilePersonalData.FROM_BUSINESS_MODEL.apply(this._profileService.saveProfilePersonalData(profileId, (ProfilePersonalData)ObjectUtil.checkNotNull((Object)de.justsoftware.profile.api.model.ProfilePersonalData.TO_BUSINESS_MODEL.apply(profilePersonal)), authContext));
        }
        catch (ValidatableException e) {
            throw new ServiceException("Failed save the profile personal data", (Throwable)e);
        }
    }

    @RequestMapping(value={"/{profileId}/delete"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ApiOperation(value="Deletes an existing user. Needs delete user permissions in every tenant the user is a member of.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - deletes profile of user with the given id"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public void deleteProfile(@PathVariable(value="profileId") ProfileId profileId, @AuthorizedContext AuthorizationContext authCtx) {
        this._personService.deleteOtherPerson(profileId.asPersonId(), (AuthorizationCheckContextWithUserId)authCtx);
    }
}

