/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.profile.api.controller;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.model.ProfileModuleType;
import de.justsoftware.profile.api.model.ProfileAttributesConfiguration;
import de.justsoftware.profile.api.model.ProfileSectionConfiguration;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/profile/api/v1/attributes"})
@Api(tags={"Profile Attributes"})
public class ProfileAttributesController {
    private final ProfileService _profileService;
    private final Settings _settings;

    @Autowired
    public ProfileAttributesController(ProfileService profileService, Settings settings) {
        this._profileService = profileService;
        this._settings = settings;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, path={"/configuration"}, produces={"application/json"})
    @ApiOperation(value="get the general profile attributes configuration", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns profile attributes configuration"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ProfileAttributesConfiguration getConfiguration(@AuthorizedContext AuthorizationContext authContext) {
        de.justsoftware.onx.profile.model.ProfileAttributesConfiguration configBM = this._profileService.getAttributesConfigurationForEditing((AuthorizationCheckContext)authContext);
        ImmutableList sectionsBM = FluentIterable.from((Iterable)configBM.getSections()).transform(ProfileSectionConfiguration.FROM_BUSINESS_MODEL).toList();
        ImmutableSet hiddenPersonFields = this._settings.getHiddenPersonFields();
        ImmutableSet restrictedPersonFields = ImmutableSet.copyOf((Collection)this._settings.getModificationRestrictedPersonFields());
        return new ProfileAttributesConfiguration((ImmutableSet<ProfileModuleType>)configBM.getModules(), null, (ImmutableList<ProfileSectionConfiguration>)sectionsBM, (ImmutableSet<String>)hiddenPersonFields, (ImmutableSet<String>)restrictedPersonFields);
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.PUT}, path={"/configuration"}, produces={"application/json"})
    @ApiOperation(value="updates the general profile attributes configuration", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns updated profile attributes configuration"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ProfileAttributesConfiguration updateConfiguration(@RequestBody ProfileAttributesConfiguration configuration, @AuthorizedContext AuthorizationContext authContext) {
        ImmutableList sectionsBM = FluentIterable.from(configuration.getSections()).transform(ProfileSectionConfiguration.TO_BUSINESS_MODEL).toList();
        de.justsoftware.onx.profile.model.ProfileAttributesConfiguration configBM = new de.justsoftware.onx.profile.model.ProfileAttributesConfiguration(configuration.getModules(), sectionsBM);
        this._profileService.setAttributesConfiguration(configBM, (AuthorizationCheckContext)authContext);
        return configuration;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, path={"/translation/default"}, produces={"application/json"})
    @ApiOperation(value="get the translations of the configured profile attributes", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns profile attributes translation"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ImmutableMap<String, Object> getTranslation() {
        return this._profileService.getProfileAttributesDefaultTranslations();
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, path={"/configuration/{profileId}"}, produces={"application/json"})
    @ApiOperation(value="get the visible profile attributes configuration for the current user", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns visible profile attributes configuration"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ProfileAttributesConfiguration getProfileConfiguration(@PathVariable(value="profileId") ProfileId profileId, @AuthorizedContext AuthorizationContext authContext) {
        de.justsoftware.onx.profile.model.ProfileAttributesConfiguration configBM = this._profileService.getVisibleAttributesConfiguration(profileId, (AuthorizationCheckContext)authContext);
        ImmutableList sectionsBM = FluentIterable.from((Iterable)configBM.getSections()).transform(ProfileSectionConfiguration.FROM_BUSINESS_MODEL).toList();
        ImmutableSet editableRoles = FluentIterable.from((Iterable)this._profileService.getEditableRolesForProfile(profileId, (SearchAuthorizationCheckContext)authContext)).transform(Role.TO_NAME).toSet();
        ImmutableSet hiddenPersonFields = this._settings.getHiddenPersonFields();
        ImmutableSet restrictedPersonFields = ImmutableSet.copyOf((Collection)this._settings.getModificationRestrictedPersonFields());
        return new ProfileAttributesConfiguration((ImmutableSet<ProfileModuleType>)configBM.getModules(), (ImmutableSet<String>)editableRoles, (ImmutableList<ProfileSectionConfiguration>)sectionsBM, (ImmutableSet<String>)hiddenPersonFields, (ImmutableSet<String>)restrictedPersonFields);
    }
}

