/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.kafka.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.kafka.KafkaConfigurationProvider;
import de.justsoftware.people.kafka.impl.KafkaConfiguration;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducerImpl;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@ParametersAreNonnullByDefault
public class KafkaConfiguration {
    private static final String SEVEN_DAYS_IN_MS = "604800000";
    private static final ImmutableMap<String, String> DEFAULT_TOPIC_CONFIG = ImmutableMap.of((Object)"delete.retention.ms", (Object)"604800000", (Object)"segment.ms", (Object)"604800000", (Object)"cleanup.policy", (Object)"compact");

    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    @Nonnull
    public KafkaCleaningProducer<String, String> createStringProducer(KafkaConfigurationProvider kafkaConfigurationProvider) {
        Properties props = kafkaConfigurationProvider.producerConfig();
        return new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(props), tp -> KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)tp, (Properties)kafkaConfigurationProvider.consumerConfig(null)));
    }

    @Nonnull
    @Bean
    public KafkaAdmin admin(@Value(value="${kafka.bootstrapServers}") String bootstrapServers) {
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers);
        KafkaAdmin admin = new KafkaAdmin((Map)configs);
        admin.setFatalIfBrokerNotAvailable(true);
        return admin;
    }

    @Nonnull
    private NewTopic defaultTopicFactory(String name, int partitions) {
        ImmutableMap defaultTopicConfig = ImmutableMap.of((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"cleanup.policy", (Object)"compact");
        NewTopic topic = new NewTopic(name, partitions, 1);
        return topic.configs((Map)defaultTopicConfig);
    }

    @Nonnull
    @Bean
    public NewTopic userGroupImportTopic() {
        return this.defaultTopicFactory("just.people.import.userGroup", 1);
    }

    @Nonnull
    @Bean
    public NewTopic userGroupMembersImportTopic() {
        return this.defaultTopicFactory("just.people.import.userGroupMembers", 1);
    }

    @Nonnull
    @Bean
    public NewTopic searchIndexTopic() {
        NewTopic topic = new NewTopic("just.people.search.index", 1, 1);
        ImmutableMap config = ImmutableMap.of((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"cleanup.policy", (Object)"delete");
        return topic.configs((Map)config);
    }

    @Nonnull
    @Bean
    public NewTopic userGroupTopic() {
        return this.defaultTopicFactory("just.people.userGroup", 5);
    }

    @Nonnull
    @Bean
    public NewTopic userGroupMembersTopic() {
        return this.defaultTopicFactory("just.people.userGroupMembers", 5);
    }
}

