/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.usergroup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupBO;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.permission.client.model.Role;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface UserGroupRepository {
    @CheckForNull
    public UserGroupBO getUserGroup(UserGroupId var1);

    @Nonnull
    public UserGroupId createImportedUserGroup(UserGroupId var1, String var2, TenantId var3);

    @Nonnull
    public UserGroupId createUserGroup(String var1, ProfileId var2, TenantId var3);

    @CheckForNull
    public UserGroupId createTenantUserGroup(String var1, TenantId var2);

    public void addMembersToGroup(UserGroupId var1, Set<ProfileId> var2);

    public void removeMembersFromGroup(UserGroupId var1, Set<ProfileId> var2);

    @Nonnull
    public Set<ProfileId> getMembersOfGroup(UserGroupId var1);

    @Nonnull
    public ImmutableSetMultimap<ProfileId, UserGroupId> getUserGroupsForProfiles(Set<ProfileId> var1);

    public int forAllUserGroups(Consumer<UserGroupBO> var1);

    public int forAllUserGroupMemberships(BiConsumer<UserGroupId, ProfileId> var1);

    public void deleteUserGroup(UserGroupId var1);

    public void renameUserGroup(UserGroupId var1, String var2);

    @Nonnull
    public ImmutableSet<UserGroupId> checkUserGroupsForProfile(ProfileId var1, Set<TenantId> var2);

    @Nonnull
    public ImmutableTable<UserGroupId, Role, UserGroupRole> getUserGroupRoles(ImmutableSet<UserGroupId> var1);

    public void setUserGroupRoles(UserGroupId var1, Map<Role, UserGroupRole> var2);

    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroupIdsWithPermissionRole(Role var1);

    @Nonnull
    public ImmutableMap<UserGroupId, UserGroupBO> getUserGroups(Set<UserGroupId> var1);

    public void updateUserGroup(UserGroupId var1, String var2, TenantId var3);

    @CheckForNull
    public UserGroupId getAllTenantUsersGroupId(TenantId var1);

    public void migrateTenantRole(Role var1, Role var2);

    @Nonnull
    public ImmutableSet<TenantId> getTenantIdsFromRole();
}

