/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.model.profile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.DynamicProfileFields;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.profile.StaticProfileFields;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileSearchIndexModel {
    private final StaticProfileFields _staticProfileFields;
    private final DynamicProfileFields _fields;
    private final ImmutableSet<UserGroupId> _userGroupIds;
    private final ImmutableSet<TenantId> _tenantIds;
    private final ImmutableSet<String> _visibleForRoles;

    public ProfileSearchIndexModel(StaticProfileFields staticProfileFields, DynamicProfileFields fields, ImmutableSet<UserGroupId> userGroupIds, ImmutableSet<TenantId> tenantIds, ImmutableSet<String> visibleForRoles) {
        this._staticProfileFields = staticProfileFields;
        this._fields = fields;
        this._userGroupIds = userGroupIds;
        this._tenantIds = tenantIds;
        this._visibleForRoles = visibleForRoles;
    }

    @Nonnull
    public ProfileId getId() {
        return this._staticProfileFields.getId();
    }

    @Nonnull
    public String getFirstName() {
        return this._staticProfileFields.getFirstName();
    }

    @Nonnull
    public String getLastName() {
        return this._staticProfileFields.getLastName();
    }

    @Nonnull
    public String getTitle() {
        return this._staticProfileFields.getTitle();
    }

    @Nonnull
    public String getAdditionalTitle() {
        return this._staticProfileFields.getAdditionalTitle();
    }

    @Nonnull
    public String getProfileHash() {
        return this._staticProfileFields.getProfileHash();
    }

    @Nonnull
    public String getImageUrl() {
        return this._staticProfileFields.getImageUrl();
    }

    public boolean isBlocked() {
        return this._staticProfileFields.isBlocked();
    }

    public boolean isActive() {
        return this._staticProfileFields.isActive();
    }

    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroupIds() {
        return this._userGroupIds;
    }

    @Nonnull
    public Map<String, Collection<String>> getFields() {
        return this._fields.getFields();
    }

    @Nonnull
    public ImmutableSet<TenantId> getTenantIds() {
        return this._tenantIds;
    }

    @Nonnull
    public ImmutableSet<String> getVisibleForRoles() {
        return this._visibleForRoles;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("firstName", (Object)this.getFirstName()).add("lastName", (Object)this.getLastName()).add("title", (Object)this.getTitle()).add("additionalTitle", (Object)this.getAdditionalTitle()).add("profileHash", (Object)this.getProfileHash()).add("imageUrl", (Object)this.getImageUrl()).add("blocked", this.isBlocked()).add("active", this.isActive()).add("fields", (Object)this._fields).add("userGroupIds", (Object)this._userGroupIds).add("tenantIds", (Object)this._tenantIds).add("visibleForRoles", (Object)this._visibleForRoles).toString();
    }
}

