/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import de.justsoftware.people.domain.model.AbstractUUIDBasedId;
import de.justsoftware.people.domain.model.IdParser;
import de.justsoftware.people.domain.model.ItemType;
import de.justsoftware.permission.client.model.Role;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TenantId
extends AbstractUUIDBasedId {
    public TenantId(UUID id) {
        super(id, ItemType.TENANT);
    }

    @Nonnull
    public static TenantId random() {
        return new TenantId(UUID.randomUUID());
    }

    @JsonCreator
    @Nonnull
    public static TenantId parse(String tenantId) {
        return (TenantId)IdParser.parse((ItemType)ItemType.TENANT, (String)tenantId, s -> new TenantId(UUID.fromString(s)));
    }

    @CheckForNull
    public static TenantId fromRole(Role tenantRole) {
        Optional tenantId = tenantRole.getTenantId();
        return tenantId.map(TenantId::new).orElse(null);
    }

    @Nonnull
    public Role asPermissionRole() {
        return Role.create((String)("TENANT," + this.getId()));
    }
}

