/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import de.justsoftware.people.business.search.model.SearchableField;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PagedResult<T> {
    private final long _offset;
    private final long _totalCount;
    private final ImmutableList<T> _rows;
    private ImmutableMultimap<SearchableField, String> _facets;

    public PagedResult(long offset, long totalCount, ImmutableList<T> rows) {
        this(offset, totalCount, rows, ImmutableMultimap.of());
    }

    public PagedResult(long offset, long totalCount, ImmutableList<T> rows, ImmutableMultimap<SearchableField, String> facets) {
        this._offset = offset;
        this._totalCount = totalCount;
        this._rows = rows;
        this._facets = facets;
    }

    public long getOffset() {
        return this._offset;
    }

    public long getTotalCount() {
        return this._totalCount;
    }

    @Nonnull
    public ImmutableList<T> getRows() {
        return this._rows;
    }

    @Nonnull
    public ImmutableMultimap<SearchableField, String> getFacets() {
        return this._facets;
    }
}

