/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.usergroup;

import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.UserGroupIdProfileIdPair;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupBO;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.permission.client.model.Role;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.JdbcType;

@Mapper
@ParametersAreNonnullByDefault
public interface UserGroupMapper {
    @ConstructorArgs(value={@Arg(javaType=UserGroupId.class, column="id", id=true), @Arg(javaType=TenantId.class, column="tenant_id"), @Arg(javaType=String.class, column="name", jdbcType=JdbcType.VARCHAR), @Arg(javaType=ProfileId.class, column="creator_id"), @Arg(javaType=boolean.class, column="all_tenant_users"), @Arg(javaType=boolean.class, column="imported")})
    @Select(value={"<script>", "SELECT id, tenant_id, name, creator_id, all_tenant_users, imported FROM user_group ", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=UserGroupBO.class)
    public void getUserGroups(ResultHandler<UserGroupBO> var1, @Param(value="ids") List<UserGroupId> var2);

    @Insert(value={"INSERT INTO user_group(id, tenant_id, name, creator_id, all_tenant_users, imported)", "VALUES (#{id}, #{tenantId}, #{name}, #{creator}, 'f', #{imported})"})
    public void createUserGroup(@Param(value="id") UserGroupId var1, @Nullable @Param(value="creator") ProfileId var2, @Param(value="name") String var3, @Param(value="tenantId") TenantId var4, @Param(value="imported") boolean var5);

    @Insert(value={"<script>", "INSERT INTO user_group(id, tenant_id, name, all_tenant_users)", "   SELECT #{id}, #{tenantId}, #{name}, 't'", "   <if test=\"_databaseId == 'ORACLE'\">FROM dual</if>", "   WHERE NOT EXISTS (", "       SELECT 1 FROM user_group WHERE tenant_id = #{tenantId} and all_tenant_users = 't')", "</script>"})
    public void createAllTenantUsersGroup(@Param(value="id") UserGroupId var1, @Param(value="name") String var2, @Param(value="tenantId") TenantId var3);

    @Insert(value={"<script>", "INSERT INTO user_group_member(user_group_id, profile_id)", "   SELECT #{userGroupId}, #{memberId}", "   <if test=\"_databaseId == 'ORACLE'\">FROM dual</if>", "   WHERE NOT EXISTS (", "       SELECT 1 FROM user_group_member WHERE user_group_id = #{userGroupId} and profile_id = #{memberId})", "</script>"})
    public void addMemberToGroup(@Param(value="userGroupId") UserGroupId var1, @Param(value="memberId") ProfileId var2);

    @Delete(value={"DELETE FROM user_group_member WHERE user_group_id = #{userGroupId} and profile_id = #{memberId}"})
    public void removeMemberFromGroup(@Param(value="userGroupId") UserGroupId var1, @Param(value="memberId") ProfileId var2);

    @Select(value={"SELECT profile_id FROM user_group_member WHERE user_group_id = #{userGroupId}"})
    @Nonnull
    @ResultType(value=ProfileId.class)
    public Set<ProfileId> getMembersOfGroup(UserGroupId var1);

    @ConstructorArgs(value={@Arg(javaType=UserGroupId.class, column="id", id=true), @Arg(javaType=TenantId.class, column="tenant_id"), @Arg(javaType=String.class, column="name", jdbcType=JdbcType.VARCHAR), @Arg(javaType=ProfileId.class, column="creator_id"), @Arg(javaType=boolean.class, column="all_tenant_users"), @Arg(javaType=boolean.class, column="imported")})
    @Select(value={"SELECT id, tenant_id, name, creator_id, all_tenant_users, imported FROM user_group"})
    @ResultType(value=UserGroupBO.class)
    public void forAllUserGroups(ResultHandler<UserGroupBO> var1);

    @Select(value={"<script>", "SELECT profile_id, user_group_id", "FROM user_group_member", "WHERE profile_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="profile_id", property="key", javaType=ProfileId.class), @Result(column="user_group_id", property="value", javaType=UserGroupId.class)})
    @ResultType(value=Map.class)
    public void getUserGroupsForProfiles(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<ProfileId> var2);

    @ConstructorArgs(value={@Arg(javaType=UserGroupId.class, column="user_group_id"), @Arg(javaType=ProfileId.class, column="profile_id")})
    @Select(value={"SELECT user_group_id, profile_id FROM user_group_member"})
    @ResultType(value=UserGroupIdProfileIdPair.class)
    public void forAllUserGroupMemberships(ResultHandler<UserGroupIdProfileIdPair> var1);

    @Delete(value={"DELETE FROM user_group WHERE id = #{groupId}"})
    public void deleteUserGroup(@Param(value="groupId") UserGroupId var1);

    @Update(value={"UPDATE user_group SET name = #{name} WHERE id = #{groupId}"})
    public void renameUserGroup(UserGroupId var1, String var2);

    @Select(value={"<script> ", "SELECT g.id from user_group_member m JOIN user_group g ON m.user_group_id=g.id WHERE profile_id=#{profileId} ", "AND g.tenant_id ", "NOT IN (<foreach collection='tenantIds' item='tenantId' separator=','>#{tenantId}</foreach>)", "</script>"})
    @ResultType(value=UserGroupId.class)
    @Nonnull
    public Set<UserGroupId> getUserGroupsToRemoveForProfile(@Param(value="profileId") ProfileId var1, @Param(value="tenantIds") Set<TenantId> var2);

    @Select(value={"<script>", "SELECT user_group_id, role, user_group_role FROM user_group_roles", "WHERE user_group_id IN (<foreach collection='user_groups' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="user_group_id", property="row", javaType=UserGroupId.class), @Result(column="role", property="col", javaType=Role.class), @Result(column="user_group_role", property="value", javaType=UserGroupRole.class)})
    @ResultType(value=Map.class)
    public void getUserGroupRoles(ResultHandler<Map<String, Object>> var1, @Param(value="user_groups") List<UserGroupId> var2);

    @Insert(value={"INSERT INTO user_group_roles (user_group_id, role, user_group_role) VALUES (#{user_group_id}, #{role}, #{user_group_role})"})
    public void setUserGroupRoles(@Param(value="user_group_id") UserGroupId var1, @Param(value="role") Role var2, @Param(value="user_group_role") UserGroupRole var3);

    @Update(value={"DELETE FROM user_group_roles WHERE user_group_id=#{groupId}"})
    public void deleteUserGroupRoles(UserGroupId var1);

    @Select(value={"SELECT user_group_id FROM user_group_roles WHERE role=#{role}"})
    @ResultType(value=UserGroupId.class)
    @Nonnull
    public Set<UserGroupId> getUserGroupIdsWithPermissionRole(@Param(value="role") Role var1);

    @Update(value={"UPDATE user_group SET name = #{name}, tenant_id = #{tenantId} WHERE id = #{id}"})
    public void updateUserGroup(@Param(value="id") UserGroupId var1, @Param(value="name") String var2, @Param(value="tenantId") TenantId var3);

    @Select(value={"SELECT id FROM user_group WHERE tenant_id = #{tenantId} AND all_tenant_users='t' "})
    @CheckForNull
    @ResultType(value=UserGroupId.class)
    public UserGroupId getTenantUserGroup(@Param(value="tenantId") TenantId var1);

    @Select(value={"Select role from user_group_roles where role LIKE 'TENANT,%'"})
    @ResultType(value=Role.class)
    @Nonnull
    public Set<Role> getAllTenantRoles();

    @Update(value={"UPDATE user_group_roles ugr SET role = #{allUsersGroupRole} ", "WHERE role = #{tenantRole} ", "AND NOT EXISTS (SELECT 1 FROM user_group_roles ugr2 WHERE role = #{allUsersGroupRole} and ugr.user_group_id = ugr2.user_group_id )"})
    public void migrateTenantRole(@Param(value="tenantRole") Role var1, @Param(value="allUsersGroupRole") Role var2);

    @Delete(value={"DELETE FROM user_group_roles WHERE role = #{tenantRole}"})
    public void deleteAllTenantRoles(@Param(value="tenantRole") Role var1);
}

