/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.transaction;

import de.justsoftware.people.domain.transaction.TransactionCallback;
import de.justsoftware.people.domain.transaction.TransactionSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionOperations;

@Service
@ParametersAreNonnullByDefault
public class TransactionSupportImpl
implements TransactionSupport {
    private final TransactionOperations _transactionOperations;

    @Autowired
    public TransactionSupportImpl(TransactionOperations transactionOperations) {
        this._transactionOperations = transactionOperations;
    }

    public <T> T doInTransaction(TransactionCallback<T> callback) {
        return (T)this._transactionOperations.execute(status -> callback.doInTransaction());
    }

    public void doInTransaction(Runnable action) {
        this._transactionOperations.execute(status -> {
            action.run();
            return null;
        });
    }
}

