/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.search;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.domain.impl.search.SolrQueryHelper;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;

@ParametersAreNonnullByDefault
class SolrQueryHelper {
    SolrQueryHelper() {
    }

    @Nonnull
    private static String escapeQueryChars(String input) {
        return ClientUtils.escapeQueryChars((String)input);
    }

    @Nonnull
    private static String quote(String input) {
        return "\"" + input + "\"";
    }

    static void addFilterQuery(SolrQuery query, String field, Iterable<String> values, String ... tags) {
        ImmutableList escapedValues = (ImmutableList)StreamSupport.stream(values.spliterator(), false).map(SolrQueryHelper::escapeQueryChars).map(SolrQueryHelper::quote).collect(ImmutableList.toImmutableList());
        LocalParams localParams = new LocalParams(new LocalParam[]{new LocalParam("tag", tags)});
        query.addFilterQuery(new String[]{localParams.toSolrQuery() + field + ":(" + Joiner.on((String)" OR ").join((Iterable)escapedValues) + ")"});
    }

    static void setFacetFieldLimit(SolrQuery query, String field, int limit) {
        query.set("f." + field + ".facet.limit", limit);
    }

    static void setFacetContains(SolrQuery query, String field, String value) {
        query.set("f." + field + ".facet.contains", new String[]{value});
    }

    @Nonnull
    static String queryFieldWithBoost(String name, float boostFactor) {
        return name + "^" + boostFactor;
    }

    static void addFacetFieldWithExclusion(SolrQuery query, String field, @Nullable String facetkey, String ... exclusionFilter) {
        LocalParams localParams = new LocalParams(new LocalParam[]{new LocalParam("ex", exclusionFilter)});
        if (!Strings.isNullOrEmpty((String)facetkey)) {
            localParams.add(new LocalParam("key", new String[]{facetkey}));
        }
        query.addFacetField(new String[]{localParams.toSolrQuery() + field});
    }
}

