/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.search;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.model.SearchableField;
import de.justsoftware.people.domain.RepositoryCommunicationException;
import de.justsoftware.people.domain.RepositoryException;
import de.justsoftware.people.domain.impl.search.ProfileDynamicAttributeIndexer;
import de.justsoftware.people.domain.impl.search.SearchableFieldToSearchTagVisitor;
import de.justsoftware.people.domain.impl.search.SearchableFieldToSolrFacetFieldVisitor;
import de.justsoftware.people.domain.impl.search.SearchableFieldToSolrFilterFieldVisitor;
import de.justsoftware.people.domain.impl.search.SolrQueryHelper;
import de.justsoftware.people.domain.model.AbstractId;
import de.justsoftware.people.domain.model.PagedResult;
import de.justsoftware.people.domain.model.SearchModel;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.DynamicProfileFields;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.profile.ProfileSearchIndexModel;
import de.justsoftware.people.domain.model.profile.ProfileSearchReadModel;
import de.justsoftware.people.domain.model.profile.StaticProfileFields;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupSearchIndexModel;
import de.justsoftware.people.domain.model.usergroup.UserGroupSearchModel;
import de.justsoftware.people.domain.search.SearchIndexService;
import de.justsoftware.people.domain.search.SearchReadService;
import de.justsoftware.permission.client.model.Role;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@Repository
public class SolrIntegrationImpl
implements SearchIndexService,
SearchReadService {
    static final int DEFAULT_FACET_LIMIT = 100;
    private static final String DEFAULT_QUERY = "*:*";
    private static final String QUERY_FOR_TYPE = "type:";
    private static final String SET = "set";
    private static final String OR = "OR";
    private final SolrClient _solrClient;
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final ProfileAttributeConfigService _profileAttributeConfigService;

    public SolrIntegrationImpl(SolrClient solrClient, ProfileAttributeConfigService profileAttributeConfigService) {
        this._solrClient = solrClient;
        this._profileAttributeConfigService = profileAttributeConfigService;
    }

    public void createOrUpdateProfiles(ImmutableCollection<ProfileSearchIndexModel> profiles) {
        if (profiles.isEmpty()) {
            return;
        }
        ProfileDynamicAttributeIndexer dynamicAttributeIndexer = new ProfileDynamicAttributeIndexer(this._profileAttributeConfigService.getConfigurations());
        List documents = profiles.stream().map(p -> {
            SolrInputDocument document = new SolrInputDocument(new String[0]);
            document.addField("id", (Object)p.getId().toString());
            document.addField("firstName", (Object)p.getFirstName());
            document.addField("lastName", (Object)p.getLastName());
            document.addField("title", (Object)p.getTitle());
            document.addField("additionalTitle", (Object)p.getAdditionalTitle());
            document.addField("profileHash", (Object)p.getProfileHash());
            document.addField("imageUrl", (Object)p.getImageUrl());
            document.addField("blocked", (Object)p.isBlocked());
            document.addField("active", (Object)p.isActive());
            document.addField("userGroupIds", p.getUserGroupIds().stream().map(AbstractId::toString).collect(Collectors.toList()));
            document.addField("type", (Object)"PROFILE");
            document.addField("name_sort", (Object)(p.getLastName() + " " + p.getFirstName()));
            document.addField("tenantIds", p.getTenantIds().stream().map(AbstractId::asString).collect(Collectors.toList()));
            document.addField("visible_for_roles", (Object)p.getVisibleForRoles());
            dynamicAttributeIndexer.convertForSolrIndex(p.getFields()).asMap().forEach((arg_0, arg_1) -> ((SolrInputDocument)document).addField(arg_0, arg_1));
            return document;
        }).collect(Collectors.toList());
        try {
            this._solrClient.add(documents);
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not store profiles in Solr", e);
        }
    }

    public void createOrUpdateUserGroups(Map<UserGroupId, UserGroupSearchIndexModel> userGroups) {
        if (userGroups.isEmpty()) {
            return;
        }
        List documents = userGroups.values().stream().map(userGroup -> {
            SolrInputDocument document = new SolrInputDocument(new String[0]);
            document.addField("id", (Object)userGroup.getId().asString());
            document.addField("userGroupName", (Object)userGroup.getName());
            document.addField("type", (Object)"USER_GROUP");
            document.addField("tenantIds", (Object)Lists.newArrayList((Object[])new String[]{userGroup.getTenantId().asString()}));
            document.addField("name_sort", (Object)userGroup.getName());
            document.addField("visible_for_roles", (Object)userGroup.getVisibleForRoles());
            document.addField("userGroupAllTenantUsers", (Object)userGroup.isAllTenantUsers());
            document.addField("userGroupImported", (Object)userGroup.isImported());
            return document;
        }).collect(Collectors.toList());
        try {
            this._solrClient.add(documents);
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not store user groups in Solr", e);
        }
    }

    public void deleteProfiles(Set<ProfileId> profileIds) {
        if (profileIds.isEmpty()) {
            return;
        }
        List strings = profileIds.stream().map(AbstractId::toString).collect(Collectors.toList());
        try {
            this._solrClient.deleteById(strings);
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not delete profiles from Solr", e);
        }
    }

    public void deleteUserGroups(Set<UserGroupId> userGroupIds) {
        if (userGroupIds.isEmpty()) {
            return;
        }
        List strings = userGroupIds.stream().map(AbstractId::toString).collect(Collectors.toList());
        try {
            this._solrClient.deleteById(strings);
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not delete user groups from Solr", e);
        }
    }

    public void commit(boolean waitSearcher) {
        try {
            this._solrClient.commit(false, waitSearcher, true);
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not commit Solr index", e);
        }
    }

    public void deleteAllUserGroups() {
        try {
            this._solrClient.deleteByQuery("type:USER_GROUP");
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not delete user groups", e);
        }
    }

    public void updateGroupsForProfiles(Map<ProfileId, ? extends Set<UserGroupId>> userGroupsForProfiles) {
        if (userGroupsForProfiles.isEmpty()) {
            return;
        }
        HashMap documents = new HashMap();
        userGroupsForProfiles.forEach((profileId, userGroupIds) -> {
            SolrInputDocument document = new SolrInputDocument(new String[0]);
            document.setField("id", (Object)profileId.toString());
            document.setField("userGroupIds", (Object)ImmutableMap.of((Object)"set", userGroupIds.stream().map(AbstractId::toString).collect(Collectors.toList())));
            document.setField("timestamp", (Object)ImmutableMap.of((Object)"set", (Object)new Date()));
            documents.put(profileId, document);
        });
        try {
            this.sendToSolr(documents);
        }
        catch (IOException | RuntimeException e) {
            throw new RepositoryException("Could not store memberships in Solr", (Throwable)e);
        }
    }

    private void sendToSolr(Map<ProfileId, SolrInputDocument> documents) throws IOException {
        try {
            this._solrClient.add(documents.values());
        }
        catch (SolrServerException | SolrException collectionTry) {
            for (Map.Entry<ProfileId, SolrInputDocument> entry : documents.entrySet()) {
                try {
                    this._solrClient.add(entry.getValue());
                }
                catch (SolrServerException | SolrException singleTry) {
                    this._log.warn("Failed to update group memberships for profile " + entry.getKey().asString() + " in Solr", singleTry);
                }
            }
        }
    }

    private void sendToSolr(List<SolrInputDocument> documents) throws RepositoryException {
        try {
            this._solrClient.add(documents);
        }
        catch (SolrException collectionTry) {
            for (SolrInputDocument document : documents) {
                ArrayList<Object> failedRecordIds = new ArrayList<Object>();
                try {
                    this._solrClient.add(document);
                }
                catch (SolrException singleTry) {
                    this._log.warn("Failed to add or update document with id " + document.getFieldValue("id") + " in Solr", (Throwable)singleTry);
                    failedRecordIds.add(document.getFieldValue("id"));
                }
                catch (IOException | SolrServerException e) {
                    throw new RepositoryCommunicationException("Failed to send document with id " + document.getFieldValue("id") + " to solr due to communication problem.", e);
                }
                if (failedRecordIds.isEmpty()) continue;
                throw new RepositoryException("Failed to add documents to solr: " + failedRecordIds);
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryCommunicationException("Failed to send documents to solr due to communication problem.", e);
        }
    }

    public void updateGroupName(UserGroupId userGroupId, String groupName) {
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        document.setField("id", (Object)userGroupId.toString());
        document.setField("userGroupName", (Object)ImmutableMap.of((Object)"set", (Object)groupName));
        document.setField("name_sort", (Object)ImmutableMap.of((Object)"set", (Object)groupName));
        document.setField("timestamp", (Object)ImmutableMap.of((Object)"set", (Object)new Date()));
        try {
            this._solrClient.add(document);
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not update user group name in Solr", e);
        }
    }

    public void updateVisibleForRolesForUserGroups(Map<UserGroupId, ? extends Collection<String>> visibilitiesForUserGroups) {
        if (visibilitiesForUserGroups.isEmpty()) {
            return;
        }
        ArrayList documents = new ArrayList();
        visibilitiesForUserGroups.forEach((userGroupId, roles) -> {
            SolrInputDocument document = new SolrInputDocument(new String[0]);
            document.setField("id", (Object)userGroupId.toString());
            document.setField("visible_for_roles", (Object)ImmutableMap.of((Object)"set", (Object)roles));
            document.setField("timestamp", (Object)ImmutableMap.of((Object)"set", (Object)new Date()));
            documents.add(document);
        });
        this.sendToSolr(documents);
    }

    public void updateVisibleForRolesForProfiles(Map<ProfileId, ? extends Collection<String>> rolesForProfiles) {
        if (rolesForProfiles.isEmpty()) {
            return;
        }
        ArrayList documents = new ArrayList();
        rolesForProfiles.keySet().forEach(profileId -> {
            SolrInputDocument document = new SolrInputDocument(new String[0]);
            document.setField("id", (Object)profileId.asString());
            document.setField("visible_for_roles", (Object)ImmutableMap.of((Object)"set", (Object)((Collection)rolesForProfiles.get(profileId))));
            document.setField("timestamp", (Object)ImmutableMap.of((Object)"set", (Object)new Date()));
            documents.add(document);
        });
        this.sendToSolr(documents);
    }

    public boolean isAvailable() {
        try {
            this._solrClient.ping();
            return true;
        }
        catch (IOException | SolrServerException e) {
            this._log.error("SOLR not available", e);
            return false;
        }
    }

    public PagedResult<ProfileSearchReadModel> allProfiles(TenantId tenantId, String searchString, ImmutableList<SearchFilter> searchFilter, ImmutableSet<Role> searchRoles, FacetFilter facetFilter, UserGroupId groupId, int offset, int limit) {
        try {
            SolrQuery query = this.createSolrQuery(searchString, offset, limit, null);
            query.addFilterQuery(new String[]{"type:PROFILE"});
            ImmutableList facetableFields = this._profileAttributeConfigService.getFacetableFields();
            SearchableFieldToSolrFilterFieldVisitor toSolrFilterFieldVisitor = new SearchableFieldToSolrFilterFieldVisitor(this._profileAttributeConfigService.getConfigurations());
            searchFilter.forEach(filter -> SolrQueryHelper.addFilterQuery((SolrQuery)query, (String)((String)filter.getSearchableField().accept((SearchableField.SearchableFieldVisitor)toSolrFilterFieldVisitor)), (Iterable)filter.getValues(), (String[])new String[]{(String)filter.getSearchableField().accept((SearchableField.SearchableFieldVisitor)SearchableFieldToSearchTagVisitor.INSTANCE)}));
            this.addFacetFields(query, facetableFields);
            if (facetFilter != null) {
                SolrQueryHelper.setFacetContains((SolrQuery)query, (String)facetFilter.getSearchFieldId().getId(), (String)facetFilter.getValue());
            }
            if (groupId != null) {
                query.addFilterQuery(new String[]{"userGroupIds:" + groupId});
            }
            this.addTenantIdFilter(tenantId, query);
            this.addVisibleForRolesFilter(searchRoles, query);
            QueryResponse response = this._solrClient.query((SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList results = response.getResults();
            List profiles = results.stream().map(SolrIntegrationImpl::profileFromDocument).collect(Collectors.toList());
            return new PagedResult(results.getStart(), results.getNumFound(), ImmutableList.copyOf(profiles), (ImmutableMultimap)this.extractFacetResults(response, facetableFields));
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not load profiles from Solr", e);
        }
    }

    private void addFacetFields(SolrQuery solrQuery, ImmutableList<SearchableField> facetFields) {
        facetFields.forEach(field -> {
            String facetField = (String)field.accept((SearchableField.SearchableFieldVisitor)SearchableFieldToSolrFacetFieldVisitor.INSTANCE);
            SolrQueryHelper.addFacetFieldWithExclusion((SolrQuery)solrQuery, (String)facetField, null, (String[])new String[]{(String)field.accept((SearchableField.SearchableFieldVisitor)SearchableFieldToSearchTagVisitor.INSTANCE)});
            this._profileAttributeConfigService.getConfigFor(field).ifPresent(config -> {
                if (!config.isSearchInFacetsSupported()) {
                    SolrQueryHelper.setFacetFieldLimit((SolrQuery)solrQuery, (String)facetField, (int)config.getTranslatedValues().keySet().size());
                }
            });
        });
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(100);
        solrQuery.setFacetSort("index");
    }

    @Nonnull
    private ImmutableListMultimap<SearchableField, String> extractFacetResults(QueryResponse response, ImmutableList<SearchableField> facetableFields) {
        ImmutableListMultimap.Builder facetResult = ImmutableListMultimap.builder();
        facetableFields.forEach(searchableField -> {
            List facetValues;
            String facetFieldName = (String)searchableField.accept((SearchableField.SearchableFieldVisitor)SearchableFieldToSolrFacetFieldVisitor.INSTANCE);
            FacetField facetField = response.getFacetField(facetFieldName);
            if (facetField != null && !(facetValues = facetField.getValues().stream().map(FacetField.Count::getName).filter(v -> !Strings.isNullOrEmpty((String)v)).collect(Collectors.toList())).isEmpty()) {
                facetResult.putAll(searchableField, facetValues);
            }
        });
        return facetResult.build();
    }

    @Nonnull
    private SolrQuery createSolrQuery(String queryString, int offset, int limit, @Nullable String queryFields) {
        String quotedQuery = SolrIntegrationImpl.quoteSolrQuery((String)queryString);
        SolrQuery solrQuery = Strings.isNullOrEmpty((String)quotedQuery) ? new SolrQuery("*:*").setSort("name_sort", SolrQuery.ORDER.asc) : new SolrQuery(quotedQuery).setSorts(List.of(SolrQuery.SortClause.desc((String)"score"), SolrQuery.SortClause.asc((String)"name_sort")));
        solrQuery.setStart(Integer.valueOf(offset)).setRows(Integer.valueOf(limit));
        if (!Strings.isNullOrEmpty((String)queryFields)) {
            solrQuery.add("qf", new String[]{queryFields});
        }
        return solrQuery;
    }

    public PagedResult<SearchModel> allProfilesAndUserGroups(TenantId tenantId, String searchString, ImmutableSet<Role> searchRoles, int offset, int limit) {
        try {
            if (searchRoles.isEmpty()) {
                return new PagedResult((long)offset, 0L, ImmutableList.of());
            }
            SolrQuery solrQuery = this.createSolrQuery(searchString, offset, limit, null);
            this.addTenantIdFilter(tenantId, solrQuery);
            this.addVisibleForRolesFilter(searchRoles, solrQuery);
            QueryResponse response = this._solrClient.query((SolrParams)solrQuery);
            SolrDocumentList results = response.getResults();
            List profilesAndUserGroups = results.stream().map(SolrIntegrationImpl::searchModelFromDocument).filter(Objects::nonNull).collect(Collectors.toList());
            return new PagedResult(results.getStart(), results.getNumFound(), ImmutableList.copyOf(profilesAndUserGroups));
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not load profiles and user groups from Solr", e);
        }
    }

    private void addVisibleForRolesFilter(ImmutableSet<Role> searchRoles, SolrQuery solrQuery) {
        solrQuery.addFilterQuery(new String[]{"visible_for_roles:(" + Joiner.on((String)" OR ").join(searchRoles) + ")"});
    }

    private void addTypesFilter(ImmutableSet<String> types, SolrQuery solrQuery) {
        if (types.isEmpty()) {
            return;
        }
        solrQuery.addFilterQuery(new String[]{"type:(" + Joiner.on((String)" OR ").join(types) + ")"});
    }

    private void addExcludeAllTenantUsersGroupFilter(SolrQuery solrQuery) {
        solrQuery.addFilterQuery(new String[]{"-userGroupAllTenantUsers:true"});
    }

    public PagedResult<SearchModel> searchInNames(TenantId tenantId, String searchString, ImmutableSet<Role> searchRoles, ImmutableSet<String> types, int offset, int limit) {
        try {
            if (searchRoles.isEmpty()) {
                return new PagedResult((long)offset, 0L, ImmutableList.of());
            }
            String queryFields = SolrQueryHelper.queryFieldWithBoost((String)"name", (float)2.0f).concat(" namePhonetic");
            SolrQuery solrQuery = this.createSolrQuery(searchString, offset, limit, queryFields);
            this.addTypesFilter(types, solrQuery);
            this.addTenantIdFilter(tenantId, solrQuery);
            this.addVisibleForRolesFilter(searchRoles, solrQuery);
            this.addExcludeAllTenantUsersGroupFilter(solrQuery);
            QueryResponse response = this._solrClient.query((SolrParams)solrQuery);
            SolrDocumentList results = response.getResults();
            List profilesAndUserGroups = results.stream().map(SolrIntegrationImpl::searchModelFromDocument).filter(Objects::nonNull).collect(Collectors.toList());
            return new PagedResult(results.getStart(), results.getNumFound(), ImmutableList.copyOf(profilesAndUserGroups));
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not load profiles and user groups from Solr", e);
        }
    }

    public PagedResult<UserGroupSearchModel> allUserGroups(TenantId tenantId, String nameFilter, ImmutableSet<Role> searchRoles, int offset, int limit) {
        if (searchRoles.isEmpty()) {
            return new PagedResult((long)offset, 0L, ImmutableList.of());
        }
        SolrQuery solrQuery = this.createSolrQuery(nameFilter, offset, limit, null);
        solrQuery.addFilterQuery(new String[]{"type:USER_GROUP"});
        this.addTenantIdFilter(tenantId, solrQuery);
        this.addVisibleForRolesFilter(searchRoles, solrQuery);
        try {
            QueryResponse response = this._solrClient.query((SolrParams)solrQuery);
            SolrDocumentList results = response.getResults();
            List userGroups = results.stream().map(SolrIntegrationImpl::userGroupFromDocument).collect(Collectors.toList());
            return new PagedResult(results.getStart(), results.getNumFound(), ImmutableList.copyOf(userGroups));
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not load user groups from Solr", e);
        }
    }

    private void addTenantIdFilter(@Nullable TenantId tenantId, SolrQuery solrQuery) {
        if (tenantId != null) {
            solrQuery.addFilterQuery(new String[]{"tenantIds:" + tenantId});
        }
    }

    @CheckForNull
    private static SearchModel searchModelFromDocument(SolrDocument document) {
        String type;
        switch (type = (String)document.getFieldValue("type")) {
            case "PROFILE": {
                return SolrIntegrationImpl.profileFromDocument((SolrDocument)document);
            }
            case "USER_GROUP": {
                return SolrIntegrationImpl.userGroupFromDocument((SolrDocument)document);
            }
        }
        return null;
    }

    @Nonnull
    private static String quoteSolrQuery(String query) {
        StringBuilder result = new StringBuilder();
        for (String word : query.split(" ")) {
            if (Strings.isNullOrEmpty((String)word)) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append("\"").append(word).append("\"");
        }
        return result.toString();
    }

    @Nonnull
    private static ProfileSearchReadModel profileFromDocument(SolrDocument d) {
        StaticProfileFields staticProfileFields = new StaticProfileFields(ProfileId.parse((String)((String)d.getFieldValue("id"))), (String)d.getFieldValue("firstName"), (String)d.getFieldValue("lastName"), (String)d.getFieldValue("title"), (String)d.getFieldValue("additionalTitle"), (String)d.getFieldValue("profileHash"), (String)d.getFieldValue("imageUrl"), Boolean.TRUE.equals(d.getFieldValue("blocked")), Boolean.TRUE.equals(d.getFieldValue("active")));
        ImmutableMap.Builder fields = ImmutableMap.builder();
        d.getFieldNames().forEach(fieldName -> {
            if (fieldName.startsWith("profile_dynamic_")) {
                Collection values = d.getFieldValues(fieldName);
                fields.put((Object)fieldName.substring("profile_dynamic_".length()), (Object)values.stream().map(String.class::cast).collect(Collectors.toList()));
            }
        });
        Collection rawUserGroupIds = d.getFieldValues("userGroupIds");
        ImmutableSet userGroupIds = rawUserGroupIds == null ? ImmutableSet.of() : (ImmutableSet)rawUserGroupIds.stream().map(o -> UserGroupId.parse((String)((String)o))).collect(ImmutableSet.toImmutableSet());
        return new ProfileSearchReadModel(staticProfileFields, new DynamicProfileFields((Map)fields.build()), userGroupIds);
    }

    @Nonnull
    private static UserGroupSearchModel userGroupFromDocument(SolrDocument document) {
        return new UserGroupSearchModel(UserGroupId.parse((String)((String)document.getFieldValue("id"))), (String)document.getFieldValue("userGroupName"), Boolean.TRUE.equals(document.getFieldValue("userGroupImported")), Boolean.TRUE.equals(document.getFieldValue("userGroupAllTenantUsers")));
    }

    public ProfileSearchReadModel findProfile(ProfileId profileId, ImmutableSet<Role> searchRoles) {
        try {
            SolrQuery query = new SolrQuery("id:" + profileId.asString());
            this.addVisibleForRolesFilter(searchRoles, query);
            QueryResponse response = this._solrClient.query((SolrParams)query);
            SolrDocumentList results = response.getResults();
            return (ProfileSearchReadModel)Iterables.getFirst((Iterable)results.stream().map(SolrIntegrationImpl::profileFromDocument).collect(Collectors.toList()), null);
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not load profile from Solr", e);
        }
    }

    public PagedResult<ProfileSearchReadModel> getProfiles(ImmutableSet<ProfileId> profilesIds) {
        try {
            if (profilesIds.isEmpty()) {
                return new PagedResult(0L, 0L, ImmutableList.of());
            }
            SolrQuery query = new SolrQuery("*:*");
            query.addFilterQuery(new String[]{"id:(" + Joiner.on((String)" OR ").join(profilesIds) + ")"});
            QueryResponse response = this._solrClient.query((SolrParams)query);
            SolrDocumentList results = response.getResults();
            List profiles = results.stream().map(SolrIntegrationImpl::profileFromDocument).collect(Collectors.toList());
            return new PagedResult(results.getStart(), results.getNumFound(), ImmutableList.copyOf(profiles));
        }
        catch (IOException | SolrServerException e) {
            throw new RepositoryException("Could not load profiles from Solr", e);
        }
    }
}

