/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import de.justsoftware.people.business.usergroup.UserGroupPublisher;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/internal"})
public class InternalPeopleController {
    private final UserGroupService _userGroupService;
    private final UserGroupPublisher _userGroupPublisher;

    public InternalPeopleController(UserGroupService userGroupService, UserGroupPublisher userGroupPublisher) {
        this._userGroupService = userGroupService;
        this._userGroupPublisher = userGroupPublisher;
    }

    @PostMapping(value={"publish/groups"})
    public void publishUserGroups() {
        this._userGroupPublisher.publishAllUserGroups();
    }

    @PostMapping(value={"reindex/groups"})
    public void reindexUserGroups() {
        this._userGroupService.reindexAllGroups();
    }

    @PostMapping(value={"status"})
    public void status() {
    }

    @Nonnull
    @GetMapping(value={"version"}, produces={"text/plain"})
    public String version() {
        return "12.19.11-2839";
    }

    @PutMapping(value={"migrate/allUsersRole"})
    public void migrateTenantRole() {
        this._userGroupService.migrateAllUsersRole();
    }

    @Nonnull
    @GetMapping(value={"/{tenantId}/allUsersGroup"})
    public UserGroupId getAllTenantUsersGroup(@PathVariable TenantId tenantId) {
        return this._userGroupService.createOrGetAllTenantUsersGroup(tenantId);
    }
}

