/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.externallink.ExternalLinkId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.TokenEndpoint;
import springfox.documentation.service.TokenRequestEndpoint;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ParametersAreNonnullByDefault
public class SwaggerConfig {
    private static final String OAUTH2_SCOPE = "api";
    private static final String OAUTH2_SCOPE_DESC = "Access to all your data.";
    private static final String AUTH_SCHEME_NAME = "implicitAuth";
    private static final String SWAGGER_CLIENT_ID = "swagger";

    @Bean(name={"peopleApiSwagger"})
    @Nonnull
    public Docket peopleApi() {
        return new Docket(DocumentationType.SWAGGER_2).groupName("People - Public API").apiInfo(new ApiInfoBuilder().title("Just People - Public REST API").description("REST API of Just People").termsOfServiceUrl("https://cloud.just.social/toro/terms").version("1.0").contact(new Contact("Justsoftware AG", "https://cloud.just.social", "info@justsoftwareag.com")).build()).securitySchemes((List)this.securitySchemes()).securityContexts((List)this.securityContexts("/api")).alternateTypeRules(this.idTypeRules()).ignoredParameterTypes(new Class[]{AuthorizationContext.class}).select().apis(RequestHandlerSelectors.any()).paths(this.paths("/api")).build();
    }

    @Nonnull
    private AlternateTypeRule[] idTypeRules() {
        TypeResolver typeResolver = new TypeResolver();
        return new AlternateTypeRule[]{AlternateTypeRules.newRule((Type)typeResolver.resolve(ProfileId.class, new Type[0]), (Type)typeResolver.resolve(String.class, new Type[0])), AlternateTypeRules.newRule((Type)typeResolver.resolve(TenantId.class, new Type[0]), (Type)typeResolver.resolve(String.class, new Type[0])), AlternateTypeRules.newRule((Type)typeResolver.resolve(UserGroupId.class, new Type[0]), (Type)typeResolver.resolve(String.class, new Type[0])), AlternateTypeRules.newRule((Type)typeResolver.resolve(ExternalLinkId.class, new Type[0]), (Type)typeResolver.resolve(String.class, new Type[0]))};
    }

    @Nonnull
    private Predicate<String> paths(String apiRoot) {
        return PathSelectors.regex((String)(apiRoot + "/*.*"));
    }

    @Nonnull
    private ImmutableList<SecurityContext> securityContexts(String apiRoot) {
        return ImmutableList.of((Object)this.oauth2SecurityContext(apiRoot));
    }

    @Nonnull
    private SecurityContext oauth2SecurityContext(String apiRoot) {
        return SecurityContext.builder().securityReferences((List)this.oauth2SecurityReferences()).forPaths(this.paths(apiRoot)).build();
    }

    @Nonnull
    private ImmutableList<SecurityReference> oauth2SecurityReferences() {
        return ImmutableList.of((Object)this.implicitOAuth2SecurityReference());
    }

    @Nonnull
    private SecurityReference implicitOAuth2SecurityReference() {
        return SecurityReference.builder().reference(AUTH_SCHEME_NAME).scopes(new AuthorizationScope[]{this.oauthScope()}).build();
    }

    @Nonnull
    private AuthorizationScope oauthScope() {
        return new AuthorizationScope(OAUTH2_SCOPE, OAUTH2_SCOPE_DESC);
    }

    @Nonnull
    private ImmutableList<SecurityScheme> securitySchemes() {
        return ImmutableList.of((Object)this.oauth2SecurityScheme());
    }

    @Nonnull
    private SecurityScheme oauth2SecurityScheme() {
        return new OAuthBuilder().name(AUTH_SCHEME_NAME).scopes((List)ImmutableList.of((Object)this.oauthScope())).grantTypes((List)ImmutableList.of((Object)this.authorizationCodeGrant())).build();
    }

    @Nonnull
    private GrantType authorizationCodeGrant() {
        return new AuthorizationCodeGrant(new TokenRequestEndpoint("/toro/oauth/authorize", SWAGGER_CLIENT_ID, null), new TokenEndpoint("/toro/oauth/token", "access_token"));
    }

    @Bean
    @Nonnull
    public SecurityConfiguration securityConfiguration() {
        return SecurityConfigurationBuilder.builder().appName("JUST PEOPLE Swagger UI").clientId(SWAGGER_CLIENT_ID).clientSecret("").realm("rest-api").scopeSeparator(",").build();
    }
}

