/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.google.common.collect.ImmutableList;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.people.config.JustOpaqueTokenIntrospector;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Order(value=0x7FFFFFF8)
@ParametersAreNonnullByDefault
public class RestSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String INTERNAL_API = "/internal/**";
    private static final OrRequestMatcher ALLOW_COOKIE_ONLY_AUTH = new OrRequestMatcher((List)ImmutableList.of((Object)new AntPathRequestMatcher("/api/profiles/export")));
    private final JwtAuthenticationProcessingFilter _authenticationProcessingFilter;
    private final String _clientId;
    private final String _clientSecret;
    private final String _checkTokenEndpoint;

    @Autowired
    public RestSecurityConfig(JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter, @Value(value="${just.people.oauth2.resource.client_id}") String clientId, @Value(value="${just.people.oauth2.resource.client_secret}") String clientSecret, @Value(value="${just.people.oauth2.resource.check_token_endpoint}") String checkTokenEndpoint) {
        super(true);
        this._authenticationProcessingFilter = jwtAuthenticationProcessingFilter;
        this._clientId = clientId;
        this._clientSecret = clientSecret;
        this._checkTokenEndpoint = checkTokenEndpoint;
    }

    public void configure(HttpSecurity http) throws Exception {
        this._authenticationProcessingFilter.applyIgnoreFilterMatcher(arg_0 -> ((AntPathRequestMatcher)new AntPathRequestMatcher(INTERNAL_API)).matches(arg_0)).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)ALLOW_COOKIE_ONLY_AUTH);
        String[] swaggerResources = new String[]{"/swagger/**", "/configuration/**", "/swagger-resources/**", "/swagger-ui.html", "/webjars/**"};
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().and()).anonymous().and()).servletApi().and()).headers().cacheControl().and().and()).authorizeRequests().antMatchers(new String[]{INTERNAL_API})).permitAll().and()).authorizeRequests().antMatchers(swaggerResources)).permitAll().and()).authorizeRequests().anyRequest()).fullyAuthenticated().and()).oauth2ResourceServer(resourceServerCustomizer -> resourceServerCustomizer.opaqueToken(opaqueTokenCustomizer -> {
            JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector(this._checkTokenEndpoint, this._clientId, this._clientSecret);
            opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
        })).addFilterAfter((Filter)this._authenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).csrf().disable();
    }
}

