/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import de.justsoftware.toolbox.performance.PerformanceLogger;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Aspect
@Configuration
@ParametersAreNonnullByDefault
@EnableAspectJAutoProxy
@ConditionalOnProperty(name={"performance.logging.enabled"})
public class PerformanceLoggerConfiguration {
    public PerformanceLoggerConfiguration(@Value(value="${performance.logging.infoMillis:50}") int infoMillis, @Value(value="${performance.logging.warnMillis:100}") int warnMillis) {
        PerformanceLogger.setPerformanceLoggerEnabled((boolean)true);
        PerformanceLogger.setThresholdTotalNanos((long)TimeUnit.MILLISECONDS.toNanos(infoMillis));
        PerformanceLogger.setThresholdWarnNanos((long)TimeUnit.MILLISECONDS.toNanos(warnMillis));
    }

    @Around(value="within(de.justsoftware.people..*)")
    public Object invokePerformanceLogger(ProceedingJoinPoint joinPoint) throws Throwable {
        return PerformanceLogger.logJoinPoint((ProceedingJoinPoint)joinPoint);
    }
}

