/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.MoreObjects;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
public class Membership {
    private final UserGroupId _userGroupId;
    private final ProfileId _profileId;
    private final String _membership;

    @JsonCreator
    public Membership(String membership) {
        this._userGroupId = UserGroupId.parse((String)membership.substring(membership.indexOf("@") + 1));
        this._profileId = ProfileId.parse((String)membership.substring(0, membership.indexOf("@")));
        this._membership = membership;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userGroupId", (Object)this.getUserGroupId()).add("profileId", (Object)this.getProfileId()).toString();
    }

    @Nonnull
    public UserGroupId getUserGroupId() {
        return this._userGroupId;
    }

    @Nonnull
    public ProfileId getProfileId() {
        return this._profileId;
    }

    @Nonnull
    public String getMembership() {
        return this._membership;
    }
}

