/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import de.justsoftware.people.business.usergroup.UserGroupPublisher;
import de.justsoftware.people.domain.model.ItemType;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupBO;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.people.domain.usergroup.UserGroupRepository;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducerState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class UserGroupPublisherImpl
implements UserGroupPublisher {
    @VisibleForTesting
    static final String VISIBILITIES_TOPIC = "just.search.index.visibilities";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupPublisherImpl.class);
    private final KafkaCleaningProducer<String, String> _kafkaProducer;
    private final UserGroupRepository _userGroupRepository;
    private final PermissionItemProducer _permissionItemProducer;
    private final SingleRoleAssignmentProducer _singleRoleAssignmentProducer;
    private final int _waitForOffsetsInS;

    @Autowired
    UserGroupPublisherImpl(@Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> kafkaProducer, UserGroupRepository userGroupRepository, PermissionItemProducer permissionItemProducer, SingleRoleAssignmentProducer singleRoleAssignmentProducer, @Value(value="${just.people.userGroupPublisher.waitForOffsetsInS:10}") int waitForOffsetsInS) {
        this._kafkaProducer = kafkaProducer;
        this._userGroupRepository = userGroupRepository;
        this._permissionItemProducer = permissionItemProducer;
        this._singleRoleAssignmentProducer = singleRoleAssignmentProducer;
        this._waitForOffsetsInS = waitForOffsetsInS;
    }

    public void publishUserGroup(UserGroupBO userGroup, Consumer<WaitForOffsets> offsetsConsumer) {
        this.sendGroupToKafka(userGroup);
        offsetsConsumer.accept(this.publishGroupToPermission(userGroup));
    }

    public void publishUserGroupDeleted(UserGroupId deletedUserGroup, ImmutableSet<ProfileId> deletedMembers) {
        this.sendToKafka("just.people.userGroup", deletedUserGroup.asString(), null);
        this._permissionItemProducer.publishDeletedItem(deletedUserGroup.asString());
        this.publishUserGroupMemberships(deletedUserGroup, ImmutableSet.of(), deletedMembers);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public WaitForOffsets publishAllUserGroups() {
        Stream.Builder waitForOffsets = Stream.builder();
        this._permissionItemProducer.republish(ItemType.USER_GROUP.name(), () -> this._userGroupRepository.forAllUserGroups(userGroup -> waitForOffsets.add(this.publishGroupToPermission(userGroup))));
        try (KafkaCleaningProducerState state = this._kafkaProducer.beginRefill(new String[]{"just.people.userGroup"});){
            this._userGroupRepository.forAllUserGroups(arg_0 -> this.sendGroupToKafka(arg_0));
            state.finishRefill();
        }
        state = this._kafkaProducer.beginRefill(new String[]{"just.people.userGroupMembers"});
        try {
            this._userGroupRepository.forAllUserGroupMemberships((userGroup, member) -> this.sendGroupMembershipToKafka(userGroup, member, true));
            state.finishRefill();
        }
        finally {
            if (state != null) {
                state.close();
            }
        }
        this._singleRoleAssignmentProducer.republish(((Predicate<Role>)Role::isProfileRole).or(Role::isUserGroupRole), () -> this._userGroupRepository.forAllUserGroupMemberships((userGroupId, profileId) -> {
            waitForOffsets.add(this.publishProfileVisibility(userGroupId, profileId));
            waitForOffsets.add(this.publishUserGroupMembership(userGroupId, profileId));
        }));
        this._singleRoleAssignmentProducer.republishForItemRoles("USER_GROUP", (Set)UserGroupRole.getAllUserGroupRoles(), () -> this._userGroupRepository.forAllUserGroups(group -> {
            UserGroupId userGroupId = group.getId();
            ImmutableTable userGroupPermissions = this._userGroupRepository.getUserGroupRoles(ImmutableSet.of((Object)userGroupId));
            userGroupPermissions.row((Object)userGroupId).forEach((role, userGroupRole) -> waitForOffsets.add(this._singleRoleAssignmentProducer.addRoleReplacement(userGroupRole.toPermissionRole(userGroupId), role)));
        }));
        return new WaitForOffsets(waitForOffsets.build());
    }

    public boolean publishUserGroupMemberships(UserGroupId userGroupId, ImmutableSet<ProfileId> membersToAdd, ImmutableSet<ProfileId> membersToDelete) {
        Stream.Builder waitForOffsetsBuilder = Stream.builder();
        membersToAdd.forEach(member -> {
            this.sendGroupMembershipToKafka(userGroupId, member, true);
            waitForOffsetsBuilder.add(this.publishUserGroupMembership(userGroupId, member));
            waitForOffsetsBuilder.add(this.publishProfileVisibility(userGroupId, member));
        });
        membersToDelete.forEach(member -> {
            this.sendGroupMembershipToKafka(userGroupId, member, false);
            waitForOffsetsBuilder.add(this._singleRoleAssignmentProducer.deleteRoleReplacement(Role.userGroupRole((UUID)((UUID)userGroupId.getId())), Role.profileRole((long)((Long)member.getId()))));
            waitForOffsetsBuilder.add(this._singleRoleAssignmentProducer.deleteRoleReplacement(Role.reader((String)member.asString()), Role.read((String)userGroupId.asString())));
        });
        WaitForOffsets waitForOffsets = new WaitForOffsets(waitForOffsetsBuilder.build());
        boolean topicProcessed = waitForOffsets.waitForOffsets(Duration.ofSeconds(this._waitForOffsetsInS));
        if (!topicProcessed) {
            LOGGER.error("Offsets haven't been processed after {}s. There might be issues with visibilites. Consider raising the timeout. Continuing...", (Object)this._waitForOffsetsInS);
            return false;
        }
        this.requestGlobalSearchProfileVisibilityUpdate(Sets.union(membersToAdd, membersToDelete).immutableCopy());
        return true;
    }

    public void requestGlobalSearchProfileVisibilityUpdate(ImmutableSet<ProfileId> changedProfileVisibilities) {
        changedProfileVisibilities.forEach(profileId -> this.sendToKafka(VISIBILITIES_TOPIC, profileId.asString(), ""));
    }

    public void publishUserGroupRoles(UserGroupId groupId, Map<Role, UserGroupRole> userGroupRolesToAdd, Map<Role, UserGroupRole> userGroupRolesToDelete, Consumer<WaitForOffsets> offsetsConsumer) {
        userGroupRolesToAdd.forEach((role, groupRole) -> offsetsConsumer.accept(this._singleRoleAssignmentProducer.addRoleReplacement(groupRole.toPermissionRole(groupId), role)));
        userGroupRolesToDelete.forEach((role, userGroupRole) -> offsetsConsumer.accept(this._singleRoleAssignmentProducer.deleteRoleReplacement(userGroupRole.toPermissionRole(groupId), role)));
    }

    @Nonnull
    private WaitForOffsets publishProfileVisibility(UserGroupId userGroupId, ProfileId p) {
        return this._singleRoleAssignmentProducer.addRoleReplacement(Role.reader((String)p.asString()), Role.read((String)userGroupId.asString()));
    }

    @Nonnull
    private WaitForOffsets publishUserGroupMembership(UserGroupId userGroupId, ProfileId p) {
        return this._singleRoleAssignmentProducer.addRoleReplacement(Role.userGroupRole((UUID)((UUID)userGroupId.getId())), Role.profileRole((long)((Long)p.getId())));
    }

    @Nonnull
    private WaitForOffsets publishGroupToPermission(UserGroupBO userGroup) {
        String parameter = userGroup.isAllTenantUsers() ? "ALL_TENANT_USERS" : (userGroup.isImported() ? "IMPORTED" : null);
        String userGroupId = userGroup.getId().asString();
        Optional<String> parent = Optional.of(userGroup.getTenantId().asString());
        return this._permissionItemProducer.publishItem(userGroupId, parent, new String[]{parameter});
    }

    private void sendGroupMembershipToKafka(UserGroupId userGroup, ProfileId member, boolean isMember) {
        this.sendToKafka("just.people.userGroupMembers", String.format("%s@%s", userGroup.asString(), member.asString()), String.valueOf(isMember));
    }

    private void sendGroupToKafka(UserGroupBO userGroup) {
        ObjectNode itemNode = JSON_MAPPER.createObjectNode();
        itemNode.set("name", (JsonNode)TextNode.valueOf((String)userGroup.getName()));
        itemNode.set("groupId", (JsonNode)TextNode.valueOf((String)userGroup.getId().toString()));
        itemNode.set("tenantId", (JsonNode)TextNode.valueOf((String)userGroup.getTenantId().toString()));
        itemNode.set("isAllTenantUsersGroup", (JsonNode)BooleanNode.valueOf((boolean)userGroup.isAllTenantUsers()));
        try {
            this.sendToKafka("just.people.userGroup", userGroup.getId().asString(), JSON_MAPPER.writeValueAsString((Object)itemNode));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void sendToKafka(String topic, String itemId, @Nullable String value) {
        this._kafkaProducer.send(new ProducerRecord(topic, (Object)itemId, (Object)value), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOGGER.error("Could not publish group to topic " + metadata.topic(), (Throwable)exception);
        }
    }
}

