/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup.impl;

import de.justsoftware.people.business.usergroup.UserGroupImportService;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.UserGroupImportModel;
import de.justsoftware.people.business.usergroup.model.UserGroupKafkaModel;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class UserGroupProcessor
extends AbstractProcessor<UserGroupId, UserGroupKafkaModel> {
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final UserGroupService _userGroupService;
    private final UserGroupImportService _userGroupImportService;

    UserGroupProcessor(UserGroupService userGroupService, UserGroupImportService userGroupImportService) {
        this._userGroupService = userGroupService;
        this._userGroupImportService = userGroupImportService;
    }

    public void init(ProcessorContext context) {
        super.init(context);
    }

    public void close() {
        try {
            super.close();
        }
        catch (RuntimeException e) {
            this._log.error("Error when closing the kafka stream context", (Throwable)e);
        }
    }

    public void process(UserGroupId userGroupId, @Nullable UserGroupKafkaModel userGroup) {
        if (userGroup != null) {
            this._log.info("Importing user groups");
            this._userGroupImportService.importUserGroup(new UserGroupImportModel(userGroupId, userGroup.getName(), userGroup.getTenantId()));
        } else {
            this._log.info("Deleting user groups");
            this._userGroupService.deleteUserGroup(userGroupId);
        }
        this.context().commit();
    }
}

