/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.tenant;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.kafka.AbstractKafkaConsumer;
import de.justsoftware.people.kafka.KafkaConfigurationProvider;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TenantConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(TenantConsumer.class);
    private static final String TENANTS_TOPIC = "just.tenants";
    private final UserGroupService _userGroupService;

    @Autowired
    public TenantConsumer(KafkaConfigurationProvider kafkaConfigurationProvider, UserGroupService userGroupService) {
        this(kafkaConfigurationProvider.modelConsumer("just.people.tenantConsumer", (Deserializer)new StringDeserializer()), userGroupService);
    }

    @VisibleForTesting
    TenantConsumer(Consumer<String, String> consumer, UserGroupService userGroupService) {
        super(consumer, new String[]{TENANTS_TOPIC});
        this._userGroupService = userGroupService;
    }

    protected void process(ConsumerRecords<String, String> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        records.forEach(r -> this.processRecord((String)r.key(), (String)r.value()));
    }

    @VisibleForTesting
    void processRecord(String key, @Nullable String value) {
        TenantId parsedTenantId = TenantId.parse((String)key);
        if (value == null) {
            this._userGroupService.deleteAllTenantUsersGroup(parsedTenantId);
            return;
        }
        this._userGroupService.createOrGetAllTenantUsersGroup(parsedTenantId);
    }
}

