/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.model.SearchableField;
import de.justsoftware.people.domain.model.PagedResult;
import de.justsoftware.people.domain.model.SearchModel;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.profile.ProfileSearchReadModel;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.search.SearchReadService;
import de.justsoftware.permission.client.model.Role;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchServiceImpl
implements SearchService {
    private final SearchReadService _searchReadService;
    private final ProfileAttributeConfigService _profileAttributeConfigService;

    public SearchServiceImpl(SearchReadService searchReadService, ProfileAttributeConfigService profileAttributeConfigService) {
        this._searchReadService = searchReadService;
        this._profileAttributeConfigService = profileAttributeConfigService;
    }

    public PagedResult<ProfileSearchReadModel> allProfiles(TenantId tenantId, String searchString, ImmutableList<SearchFilter> searchFilter, ImmutableSet<Role> searchRoles, FacetFilter facetFilter, UserGroupId groupId, int offset, int limit) {
        return this._searchReadService.allProfiles(tenantId, searchString, searchFilter, searchRoles, facetFilter, groupId, offset, limit);
    }

    public PagedResult<SearchModel> allProfilesAndUserGroups(TenantId tenantId, String searchString, ImmutableSet<Role> searchRoles, int offset, int limit) {
        return this._searchReadService.allProfilesAndUserGroups(tenantId, searchString, searchRoles, offset, limit);
    }

    public ProfileSearchReadModel findProfile(ProfileId profileId, ImmutableSet<Role> searchRoles) {
        return this._searchReadService.findProfile(profileId, searchRoles);
    }

    public PagedResult<SearchModel> searchInNames(TenantId tenantId, String searchString, ImmutableSet<Role> searchRoles, ImmutableSet<String> types, int offset, int limit) {
        return this._searchReadService.searchInNames(tenantId, searchString, searchRoles, types, offset, limit);
    }

    public ImmutableList<SearchableField> getSearchableFields() {
        return this._profileAttributeConfigService.getSearchableFields();
    }

    public ImmutableList<ProfileAttributeConfig> getSearchConfiguration() {
        return ImmutableList.copyOf((Collection)this._profileAttributeConfigService.getConfigurations().values());
    }

    public Optional<ProfileAttributeConfig> getSearchConfiguration(SearchableField searchFieldId) {
        return this._profileAttributeConfigService.getConfigFor(searchFieldId);
    }
}

