/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.impl;

import de.justsoftware.people.business.search.SearchIndexQueueService;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class SearchIndexQueueProducer
implements SearchIndexQueueService {
    private static final String SEARCH_INDEX_TOPIC = "just.people.search.index";
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchIndexQueueProducer.class);
    private final KafkaCleaningProducer<String, String> _kafkaProducer;

    public SearchIndexQueueProducer(@Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> kafkaProducer) {
        this._kafkaProducer = kafkaProducer;
    }

    public void queueToIndexVisibilities(UserGroupId userGroupId) {
        this.send(SEARCH_INDEX_TOPIC, userGroupId.asString(), "");
    }

    public void queueToIndexVisibilities(Set<ProfileId> profileIds) {
        profileIds.forEach(profileId -> this.send(SEARCH_INDEX_TOPIC, profileId.asString(), ""));
    }

    private void send(String topic, String itemId, @Nullable String value) {
        this._kafkaProducer.send(new ProducerRecord(topic, (Object)itemId, (Object)value), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOGGER.error("Could not publish to topic " + metadata.topic(), (Throwable)exception);
        }
    }
}

