/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.DynamicProfileFields;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.profile.StaticProfileFields;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ProfileKafkaModel {
    private final StaticProfileFields _staticProfileFields;
    private final DynamicProfileFields _fields;
    private final ImmutableSet<TenantId> _tenantIds;
    private final boolean _deleted;

    private ProfileKafkaModel(StaticProfileFields staticProfileFields, DynamicProfileFields fields, ImmutableSet<TenantId> tenantIds, boolean deleted) {
        this._staticProfileFields = staticProfileFields;
        this._fields = fields == null ? new DynamicProfileFields((Map)ImmutableMap.of()) : fields;
        this._tenantIds = tenantIds;
        this._deleted = deleted;
    }

    @Nonnull
    public ProfileId getId() {
        return this._staticProfileFields.getId();
    }

    @Nonnull
    public String getFirstName() {
        return this._staticProfileFields.getFirstName();
    }

    @Nonnull
    public String getLastName() {
        return this._staticProfileFields.getLastName();
    }

    @Nonnull
    public String getTitle() {
        return this._staticProfileFields.getTitle();
    }

    @Nonnull
    public String getAdditionalTitle() {
        return this._staticProfileFields.getAdditionalTitle();
    }

    @Nonnull
    public String getProfileHash() {
        return this._staticProfileFields.getProfileHash();
    }

    @Nonnull
    public String getImageUrl() {
        return this._staticProfileFields.getImageUrl();
    }

    public boolean isBlocked() {
        return this._staticProfileFields.isBlocked();
    }

    public boolean isActive() {
        return this._staticProfileFields.isActive();
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    @Nonnull
    public Map<String, Collection<String>> getFields() {
        return this._fields.getFields();
    }

    @Nonnull
    public ImmutableSet<TenantId> getTenantIds() {
        return this._tenantIds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("firstName", (Object)this.getFirstName()).add("lastName", (Object)this.getLastName()).add("title", (Object)this.getTitle()).add("additionalTitle", (Object)this.getAdditionalTitle()).add("profileHash", (Object)this.getProfileHash()).add("imageUrl", (Object)this.getImageUrl()).add("blocked", this.isBlocked()).add("active", this.isActive()).add("deleted", this._deleted).add("fields", (Object)this._fields).toString();
    }
}

