/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.impl;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.people.business.AbstractProcessorServiceImpl;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.impl.ProfileKafkaStreamsSupplier;
import de.justsoftware.people.business.profile.impl.ProfileProcessor;
import de.justsoftware.people.business.search.VisibilityService;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.domain.search.SearchIndexService;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
@Profile(value={"!test"})
public class ProfileProcessorServiceImpl
extends AbstractProcessorServiceImpl {
    private final SearchIndexService _searchIndexService;
    private final ProfileAttributeConfigService _profileAttributeConfigService;

    @Autowired
    ProfileProcessorServiceImpl(@Value(value="${kafka.bootstrapServers}") String kafkaBootstrapServers, @Value(value="${kafka.streams.stateDir}") String stateDir, SearchIndexService searchIndexService, UserGroupService userGroupService, ProfileAttributeConfigService profileAttributeConfigService, VisibilityService visibilityService, @Value(value="${just.people.profileProcessor.maxBatchSize}") int maxBatchSze, @Value(value="${just.people.profileProcessor.commitIntervalMs}") int commitIntervalMs) {
        this(searchIndexService, profileAttributeConfigService, (Supplier)new ProfileKafkaStreamsSupplier(kafkaBootstrapServers, stateDir, new ProfileProcessor(searchIndexService, userGroupService, visibilityService, maxBatchSze, commitIntervalMs)));
    }

    @VisibleForTesting
    ProfileProcessorServiceImpl(SearchIndexService searchIndexService, ProfileAttributeConfigService profileAttributeConfigService, Supplier<KafkaStreams> streamsSupplier) {
        super(streamsSupplier);
        this._searchIndexService = searchIndexService;
        this._profileAttributeConfigService = profileAttributeConfigService;
    }

    public boolean preConditionsMet() {
        return this._searchIndexService.isAvailable() && !this._profileAttributeConfigService.getConfigurations().isEmpty();
    }
}

