/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.impl;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.business.profile.AttributeNameValidator;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfigKafkaModel;
import de.justsoftware.people.business.search.model.DynamicAttributeSearchableField;
import de.justsoftware.people.business.search.model.SearchableField;
import de.justsoftware.people.business.search.model.StaticSearchableField;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
class ProfileAttributeConfigProcessor
extends AbstractProcessor<String, ProfileAttributeConfigKafkaModel[]>
implements AttributeNameValidator,
ProfileAttributeConfigService {
    private static final String DEFAULT_CONFIG_KEY = "DEFAULT";
    private ImmutableMap<String, ProfileAttributeConfig> _defaultConfig = ImmutableMap.of();

    ProfileAttributeConfigProcessor() {
    }

    public void process(String key, ProfileAttributeConfigKafkaModel[] values) {
        if (DEFAULT_CONFIG_KEY.equals(key)) {
            ImmutableMap.Builder newConfig = ImmutableMap.builder();
            Arrays.asList(values).forEach(kafkaModel -> newConfig.put((Object)kafkaModel.getName(), (Object)new ProfileAttributeConfig((ProfileAttributeConfig.AttributeType)Enums.getIfPresent(ProfileAttributeConfig.AttributeType.class, (String)kafkaModel.getType()).or((Object)ProfileAttributeConfig.AttributeType.UNKNOWN), kafkaModel.getName(), kafkaModel.isVisibleOnBadge(), kafkaModel.isSearchable(), kafkaModel.isFacetable(), kafkaModel.isClickable(), kafkaModel.isPhoneNumber(), (SearchableField)(kafkaModel.isSearchable() ? new DynamicAttributeSearchableField(kafkaModel.getName()) : null), kafkaModel.getTranslatedValues())));
            Arrays.asList(StaticSearchableField.values()).forEach(staticField -> newConfig.put((Object)staticField.getId(), (Object)ProfileAttributeConfig.createForStaticAttribute((String)staticField.getId(), (staticField == StaticSearchableField.FIRSTNAME || staticField == StaticSearchableField.LASTNAME ? 1 : 0) != 0, (SearchableField)staticField)));
            this._defaultConfig = newConfig.build();
        }
    }

    public ImmutableMap<String, ProfileAttributeConfig> getConfigurations() {
        return this._defaultConfig;
    }

    public ImmutableList<SearchableField> getSearchableFields() {
        return (ImmutableList)this.getConfigurations().values().stream().filter(ProfileAttributeConfig::isSearchable).map(ProfileAttributeConfig::getSearchFieldId).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<SearchableField> getFacetableFields() {
        return (ImmutableList)this.getConfigurations().values().stream().filter(ProfileAttributeConfig::isFacetable).map(ProfileAttributeConfig::getSearchFieldId).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    public Optional<ProfileAttributeConfig> getConfigFor(SearchableField searchFieldId) {
        return Optional.ofNullable((ProfileAttributeConfig)this.getConfigurations().get((Object)searchFieldId.getAttributeName()));
    }

    public boolean attributeNamesAreValid(ImmutableList<String> attributeNames) {
        if (attributeNames.isEmpty()) {
            return true;
        }
        return attributeNames.stream().allMatch(arg_0 -> ((ImmutableMap)this._defaultConfig).containsKey(arg_0));
    }

    public boolean attributeNameIsValid(String attributeName) {
        return this._defaultConfig.containsKey((Object)attributeName);
    }
}

