/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.model;

import com.google.common.collect.ImmutableList;
import de.justsoftware.people.application.utils.JustCsvUtils;
import de.justsoftware.people.application.utils.PagedResults;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.domain.model.PagedResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileCsvInputStream
extends InputStream {
    private Long _maxResultCount;
    private int _offset = 0;
    private final long _limit;
    private final Function<Integer, PagedResult<Profile>> _nextPageSupplier;
    private final ImmutableList<ProfileAttributeConfig> _attributeConfigs;
    private ByteArrayInputStream _currentItemByteStream;

    public ProfileCsvInputStream(@Nullable String header, Function<Integer, PagedResult<Profile>> nextPageSupplier, ImmutableList<ProfileAttributeConfig> attributeConfigs, long limit) {
        this._nextPageSupplier = nextPageSupplier;
        this._limit = limit;
        this._attributeConfigs = attributeConfigs;
        this._currentItemByteStream = header != null ? new ByteArrayInputStream(("\ufeff" + header + JustCsvUtils.LINE_SEPARATOR_STRING).getBytes(StandardCharsets.UTF_8)) : new ByteArrayInputStream("\ufeff".getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int read() throws IOException {
        int nextByte;
        if (this._currentItemByteStream == null) {
            if (!this.hasNextPage()) {
                return -1;
            }
            this.fetchNextPage();
        }
        if ((nextByte = this._currentItemByteStream.read()) == -1) {
            this._currentItemByteStream = null;
            return this.read();
        }
        return nextByte;
    }

    private boolean hasNextPage() {
        return this._maxResultCount == null || (long)this._offset < this._maxResultCount;
    }

    private void fetchNextPage() {
        PagedResult currentPagedResult = (PagedResult)this._nextPageSupplier.apply(this._offset);
        this._maxResultCount = currentPagedResult.getTotalCount();
        this._currentItemByteStream = PagedResults.toByteArrayInputStream((PagedResult)currentPagedResult, searchResult -> searchResult.toCsvString(this._attributeConfigs));
        this._offset = (int)((long)this._offset + this._limit);
    }
}

