--liquibase formatted sql

--changeset vpphan:create_initial_notification_table
CREATE TABLE notification (
    id ${uuid} NOT NULL PRIMARY KEY,
    app ${varchar64} NOT NULL,
    default_title ${varchar255} NOT NULL,
    default_text ${text} NOT NULL,
    default_secondary_text ${text},
    target_id ${varchar64},
    payload ${text},
    type ${varchar64} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    timestamp ${timestamp} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);

CREATE TABLE delivery_status (
    notification_id ${uuid} NOT NULL,
    receiver_id ${varchar64} NOT NULL,
    status ${varchar64} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL,
    PRIMARY KEY (notification_id, receiver_id),
    CONSTRAINT delivery_status_notifi_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

CREATE TABLE localized_title (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    title ${varchar255} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_title_notification_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

CREATE TABLE localized_text (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    text ${text} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_text_notification_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

CREATE TABLE localized_secondary_text (
    notification_id ${uuid} NOT NULL,
    locale ${varchar16} NOT NULL,
    secondary_text ${text} NOT NULL,
    PRIMARY KEY (notification_id, locale),
    CONSTRAINT loc_sec_text_notifi_id_fk FOREIGN KEY (notification_id) REFERENCES notification(id) ON DELETE CASCADE
);

--changeset tsubklewe:update_app_to app_id

ALTER TABLE notification RENAME COLUMN app to app_id;

--changeset tsubklewe:add column mailed to delivery_status / just-20630

ALTER TABLE delivery_status ADD should_trigger_mail ${bool} DEFAULT ${true} NOT NULL;

--changeset vpphan:delete all notifications to start a clean migration of old notifications / JUST-20585

DELETE FROM notification;

--changeset vpphan:migrate_clob_to_text dbms:postgresql

UPDATE localized_text SET text = convert_from(loread(lo_open(text::int, x'40000'::int), x'40000'::int), 'UTF-8');

UPDATE localized_secondary_text SET secondary_text = convert_from(loread(lo_open(secondary_text::int, x'40000'::int), x'40000'::int), 'UTF-8');

UPDATE notification SET
   default_text = convert_from(loread(lo_open(default_text::int, x'40000'::int), x'40000'::int), 'UTF-8'),
   default_secondary_text = convert_from(loread(lo_open(default_secondary_text::int, x'40000'::int), x'40000'::int), 'UTF-8'),
   payload = convert_from(loread(lo_open(payload::int, x'40000'::int), x'40000'::int), 'UTF-8');

SELECT lo_unlink(l.oid) FROM pg_largeobject_metadata l;

--changeset vpphan:add_delivery_status_rec_stat_idx

CREATE INDEX delivery_status_rec_stat_idx ON delivery_status(receiver_id, status);

--changeset azottnick:add_column_to_mark_delivery_status

ALTER TABLE delivery_status ADD marked ${bool} DEFAULT ${false} NOT NULL;

--changeset vpphan:add_index_to_improve_performance

CREATE INDEX delivery_status_receiver_idx ON delivery_status(receiver_id);
CREATE INDEX delivery_status_status_idx ON delivery_status(status);
CREATE INDEX delivery_status_rec_update_idx ON delivery_status(receiver_id, updated_at);
CREATE INDEX notification_timestamp_idx ON notification(timestamp);

--changeset tsubklewe:add_index_to_improve_performance

CREATE INDEX notification_type_idx ON notification(type);

--changeset tsubklewe:add_index_to_improve_app_filter_performance

CREATE INDEX notification_app_id_idx ON notification(app_id);

--changeset azottnick:create_user_group_table

CREATE TABLE user_group_member (
    PRIMARY KEY (group_id, profile_id),
    group_id ${uuid} NOT NULL,
    profile_id ${int64} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);

CREATE INDEX user_group_member_group_id_idx ON user_group_member(group_id);
