/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.security.oAuth;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.stereotype.Service;

@Service(value="profileIdExtractingConverter")
public class OAuthTokenUserAuthenticationConverter
implements UserAuthenticationConverter {
    private final String _profileIdKey = "profileId";
    private final String _authoritiesKey = "authorities";
    private final String _undefinedCredentials = "N/A";

    public Map<String, ?> convertUserAuthentication(Authentication userAuthentication) {
        ImmutableMap.Builder responseBuilder = ImmutableMap.builder();
        Collection authorities = userAuthentication.getAuthorities();
        responseBuilder.put((Object)"profileId", userAuthentication.getPrincipal());
        if (authorities != null && !authorities.isEmpty()) {
            responseBuilder.put((Object)"authorities", (Object)AuthorityUtils.authorityListToSet((Collection)authorities));
        }
        return responseBuilder.build();
    }

    public Authentication extractAuthentication(Map<String, ?> map) {
        Object profileId = map.get("profileId");
        if (profileId == null) {
            return null;
        }
        ImmutableSet emptyAuthorities = ImmutableSet.of();
        return new UsernamePasswordAuthenticationToken(profileId, (Object)"N/A", (Collection)emptyAuthorities);
    }
}

