/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.notificationservice.security.filter.ToroOAuthFilter;
import de.justsoftware.notificationservice.security.oAuth.RemoteTokenService;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

@Configuration
@EnableWebSecurity
@ParametersAreNonnullByDefault
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final JwtVerifier _jwtVerifier;
    private final RemoteTokenService _remoteTokenService;

    @Autowired
    public WebSecurityConfiguration(JwtVerifier jwtVerifier, RemoteTokenService remoteTokenService) {
        super(true);
        this._jwtVerifier = jwtVerifier;
        this._remoteTokenService = remoteTokenService;
    }

    protected void configure(HttpSecurity http) throws Exception {
        String[] swaggerResources = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        String monitoringResources = "/internal/monitoring/**";
        JwtAuthenticationProcessingFilter jwt = new JwtAuthenticationProcessingFilter(this._jwtVerifier);
        jwt.applyIgnoreFilterMatcher(arg_0 -> ((AntPathRequestMatcher)new AntPathRequestMatcher("/internal/monitoring/**")).matches(arg_0));
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().and()).anonymous().and()).headers().cacheControl().and().and()).authorizeRequests().antMatchers(swaggerResources)).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/internal/monitoring/**"})).permitAll().and()).authorizeRequests().anyRequest()).fullyAuthenticated().and()).addFilterBefore((Filter)new ToroOAuthFilter((ResourceServerTokenServices)this._remoteTokenService), AbstractPreAuthenticatedProcessingFilter.class).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
    }
}

