/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.hibernate;

import de.justsoftware.notificationservice.hibernate.Oracle10gDialectFix;
import de.justsoftware.notificationservice.hibernate.Oracle12cDialectFix;
import de.justsoftware.notificationservice.hibernate.Oracle8iDialectFix;
import de.justsoftware.notificationservice.hibernate.Oracle9iDialectFix;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;

public class OracleFixDialectResolver
implements DialectResolver {
    private static final long serialVersionUID = 1L;
    private static final DialectResolver STANDARD_DIALECT_RESOLVER = new StandardDialectResolver();

    public Dialect resolveDialect(DialectResolutionInfo info) {
        String databaseName = info.getDatabaseName();
        if ("Oracle".equals(databaseName)) {
            int majorVersion = info.getDatabaseMajorVersion();
            switch (majorVersion) {
                case 12: {
                    return new Oracle12cDialectFix();
                }
                case 10: 
                case 11: {
                    return new Oracle10gDialectFix();
                }
                case 9: {
                    return new Oracle9iDialectFix();
                }
                case 8: {
                    return new Oracle8iDialectFix();
                }
            }
            return new Oracle12cDialectFix();
        }
        return STANDARD_DIALECT_RESOLVER.resolveDialect(info);
    }
}

