/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.theme.service;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.tenantdesign.ThemeService;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MobileApiThemeService")
@ParametersAreNonnullByDefault
public class MobileThemeService {
    private final ThemeService _themeService;

    @Autowired
    public MobileThemeService(ThemeService themeService) {
        this._themeService = themeService;
    }

    @Nonnull
    public Map<AppId, String> getThemeColors(TenantId tenantId) {
        Theme defaultTheme = this._themeService.getLegacyTheme(tenantId);
        ImmutableMap.Builder appColorsBuilder = ImmutableMap.builder();
        for (CoreApp coreApp : CoreApp.values()) {
            String color;
            ThemeAttribute colorAttribute = defaultTheme.getAttribute(coreApp.getThemeAttributeType());
            String string = color = colorAttribute != null ? colorAttribute.getValue() : null;
            if (color == null) continue;
            appColorsBuilder.put((Object)coreApp.getAppId(), (Object)color);
        }
        return appColorsBuilder.build();
    }
}

