/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.task.service;

import com.google.common.collect.ImmutableList;
import de.justsoftware.mobile.api.task.model.TaskList;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.tasks.business.TaskListService;
import de.justsoftware.onx.tasks.business.model.TaskListBO;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MobileApiTaskMapper")
@ParametersAreNonnullByDefault
public class TaskMapper {
    private final TaskListService _taskListService;

    @Autowired
    public TaskMapper(TaskListService taskListService) {
        this._taskListService = taskListService;
    }

    @Nonnull
    public ImmutableList<TaskList> getTaskLists(AuthorizationContext authCtx) {
        return (ImmutableList)this._taskListService.getTaskListsForPerson(authCtx.getUserId()).stream().map(this::toTaskList).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private TaskList toTaskList(TaskListBO taskListBO) {
        return new TaskList(taskListBO.getId(), taskListBO.getName());
    }
}

