/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.service;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.people.model.PeopleApiProfile;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.mobile.api.people.model.ProfileAttributeBlock;
import de.justsoftware.mobile.api.people.model.ProfileAttributeConfiguration;
import de.justsoftware.mobile.api.people.model.ProfileAttributeSection;
import de.justsoftware.mobile.api.people.model.ProfileConfiguration;
import de.justsoftware.mobile.api.people.model.ProfileDetails;
import de.justsoftware.mobile.api.people.model.ProfileState;
import de.justsoftware.mobile.api.people.model.UpdatedProfileAttribute;
import de.justsoftware.mobile.api.people.model.UpdatedProfileBlock;
import de.justsoftware.mobile.api.people.service.PeopleService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonPlaceholderTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributes;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfileSectionConfiguration;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MobileApiPeopleMapper")
@ParametersAreNonnullByDefault
public class PeopleMapper {
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final Settings _settings;

    @Autowired
    public PeopleMapper(AuthorizationContextProvider authorizationContextProvider, Settings settings) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._settings = settings;
    }

    @CheckForNull
    public Profile toProfileNullable(@Nullable PersonTeaserModel teaser) {
        return teaser == null ? null : this.toProfile(teaser);
    }

    @Nonnull
    public Profile toProfile(PersonTeaserModel teaser) {
        return new Profile(((PersonId)teaser.getId()).asProfileId(), teaser.getFullName(), PeopleMapper.getProfileState(teaser), PeopleMapper.getUserImageUrl(teaser.getLogo()));
    }

    @Nonnull
    public Profile toProfile(PeopleApiProfile apiProfile) {
        ProfileId id = ProfileId.parseNonnull((String)apiProfile.getId());
        return new Profile(id, PeopleMapper.getFullName(apiProfile.getTitle(), apiProfile.getFirstName(), apiProfile.getLastName(), apiProfile.getAdditionalTitle()), PeopleMapper.getProfileState(apiProfile.isActive(), apiProfile.isBlocked()), apiProfile.getImageUrl());
    }

    @Nonnull
    public ImmutableList<Profile> toProfiles(ImmutableList<PeopleApiProfile> apiProfiles) {
        return (ImmutableList)apiProfiles.stream().map(this::toProfile).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public ProfileDetails toProfileDetails(PersonTeaserModel teaser, DBPerson dbPerson, AuthorizationContext authContext) {
        Profile profile = this.toProfile(teaser);
        String firstName = teaser.getFirstname();
        String lastName = teaser.getLastname();
        String title = dbPerson.getTitle();
        String additionalTitle = dbPerson.getAdditionalTitle();
        if (teaser instanceof PersonPlaceholderTeaserModel) {
            return new ProfileDetails(profile, null, firstName, lastName, null, false, false);
        }
        boolean mayEditProfile = authContext.may((ItemId)((PersonId)teaser.getId()).asProfileId(), (Action)StaticAction.PERSON_EDIT);
        if (!authContext.getUserId().equals(teaser.getId()) && this._settings.isChatEnabled() && authContext.may((Action)StaticAction.CONVERSATION_CREATE) && authContext.may((Action)StaticAction.CONNECT_USE)) {
            AuthorizationContext otherAuthContext = this._authorizationContextProvider.getAuthorizationContextForUser((PersonId)teaser.getId());
            return new ProfileDetails(profile, title, firstName, lastName, additionalTitle, otherAuthContext.may((Action)StaticAction.CONNECT_USE), mayEditProfile);
        }
        return new ProfileDetails(profile, title, firstName, lastName, additionalTitle, false, mayEditProfile);
    }

    @Nonnull
    public List<ProfileAttributeSection> toProfileAttributeSections(ProfileAttributes attributes) {
        return (List)attributes.getSections().stream().map(profileSection -> new ProfileAttributeSection(profileSection.getName(), profileSection.getType(), this.toProfileAttributeBlocks((ImmutableList<de.justsoftware.onx.profile.model.ProfileAttributeBlock>)profileSection.getAttributeBlocks()))).filter(profileSection -> profileSection.getAttributeBlocks().size() > 0).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public ProfileConfiguration toProfileConfiguration(ProfileId profileId, ProfileAttributesConfiguration config, AuthorizationContext authContext) {
        ImmutableSet hiddenPersonFields = this._settings.getHiddenPersonFields();
        ImmutableList readOnlyPersonFields = this._settings.getModificationRestrictedPersonFields();
        ImmutableList sections = (ImmutableList)config.getSections().stream().map(this::toProfileSectionConfiguration).collect(ImmutableList.toImmutableList());
        return new ProfileConfiguration(PeopleService.mayEditPersonField("person.title", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields), PeopleService.mayEditPersonField("person.firstname", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields), PeopleService.mayEditPersonField("person.lastname", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields), PeopleService.mayEditPersonField("person.additionalTitle", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields), authContext.may((ItemId)profileId, (Action)StaticAction.PERSON_EDIT_IMAGE), (ImmutableList<de.justsoftware.mobile.api.people.model.ProfileSectionConfiguration>)sections);
    }

    @Nonnull
    public ImmutableList<de.justsoftware.onx.profile.model.ProfileAttributeBlock> toProfileAttributeBlocks(ImmutableList<UpdatedProfileBlock> updatedBlocks, ProfileSectionConfiguration sectionConfig) {
        return (ImmutableList)updatedBlocks.stream().map(updatedBlock -> this.toProfileAttributeBlock((UpdatedProfileBlock)updatedBlock, sectionConfig)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static String getFullName(@CheckForNull String title, String firstName, String lastName, @CheckForNull String additionalTitle) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotBlank((String)title)) {
            result.append(title).append(" ");
        }
        result.append(firstName).append(" ").append(lastName);
        if (StringUtils.isNotBlank((String)additionalTitle)) {
            result.append(", ").append(additionalTitle);
        }
        return result.toString();
    }

    @Nonnull
    private static ProfileState getProfileState(boolean isActive, boolean isBlocked) {
        if (isBlocked) {
            return isActive ? ProfileState.BLOCKED : ProfileState.DEACTIVATED_BLOCKED;
        }
        return isActive ? ProfileState.ACTIVE : ProfileState.DEACTIVATED;
    }

    @Nonnull
    private static ProfileState getProfileState(PersonTeaserModel teaser) {
        if (teaser.isDeleted()) {
            return ProfileState.DELETED;
        }
        return PeopleMapper.getProfileState(teaser.isActive(), teaser.isBlocked());
    }

    @Nonnull
    private static String getUserImageUrl(@Nullable String imageName) {
        String path = ImageUrlUtil.getImagePath((ImageSize)ImageSize.ORIGINAL, (String)ImageType.USER_IMAGE.getPath());
        String name = ImageUrlUtil.imageOrDefault((String)imageName);
        return ImageUrlUtil.appendServer((String)(path + name));
    }

    @Nonnull
    private de.justsoftware.mobile.api.people.model.ProfileSectionConfiguration toProfileSectionConfiguration(ProfileSectionConfiguration sectionConfig) {
        return new de.justsoftware.mobile.api.people.model.ProfileSectionConfiguration(sectionConfig.getName(), sectionConfig.getType(), Boolean.TRUE.equals(sectionConfig.isMultiple()), (ImmutableList<ProfileAttributeConfiguration>)((ImmutableList)sectionConfig.getAttributes().stream().map(this::toProfileAttributeConfiguration).collect(ImmutableList.toImmutableList())));
    }

    @Nonnull
    private ProfileAttributeConfiguration toProfileAttributeConfiguration(de.justsoftware.onx.profile.model.ProfileAttributeConfiguration attributeConfig) {
        return new ProfileAttributeConfiguration(attributeConfig.getName(), attributeConfig.getType(), Boolean.TRUE.equals(attributeConfig.isRequired()), !Boolean.TRUE.equals(attributeConfig.isReadOnly()), Boolean.TRUE.equals(attributeConfig.isMultiple()), Numbers.intValue((Number)attributeConfig.getMaxLength()), (ImmutableList<String>)((ImmutableList)MoreObjects.firstNonNull((Object)attributeConfig.getValues(), (Object)ImmutableList.of())));
    }

    @Nonnull
    private ImmutableList<ProfileAttributeBlock> toProfileAttributeBlocks(ImmutableList<de.justsoftware.onx.profile.model.ProfileAttributeBlock> attributeBlocks) {
        return (ImmutableList)attributeBlocks.stream().map(attributeBlock -> new ProfileAttributeBlock(Numbers.intValue((Number)attributeBlock.getOrderIndex()), this.toProfileAttributes((ImmutableList<ProfileAttribute>)attributeBlock.getAttributes()))).filter(attributeBlock -> attributeBlock.getAttributes().size() > 0).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableList<de.justsoftware.mobile.api.people.model.ProfileAttribute> toProfileAttributes(ImmutableList<ProfileAttribute> attributes) {
        return (ImmutableList)attributes.stream().map(profileAttribute -> new de.justsoftware.mobile.api.people.model.ProfileAttribute(profileAttribute.getName(), profileAttribute.getType(), this.toProfileAttributeValues((ImmutableList<String>)profileAttribute.getValues()))).filter(profileAttribute -> profileAttribute.getValues().size() > 0).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableList<String> toProfileAttributeValues(ImmutableList<String> values) {
        return (ImmutableList)values.stream().filter(value -> !value.isBlank()).collect(ImmutableList.toImmutableList());
    }

    @CheckForNull
    private de.justsoftware.onx.profile.model.ProfileAttributeBlock toProfileAttributeBlock(UpdatedProfileBlock updatedBlock, ProfileSectionConfiguration sectionConfig) {
        ImmutableList updatedAttributes = (ImmutableList)updatedBlock.getAttributes().stream().map(updatedAttribute -> this.toProfileAttribute((UpdatedProfileAttribute)updatedAttribute, sectionConfig)).collect(ImmutableList.toImmutableList());
        return updatedAttributes.isEmpty() ? null : new de.justsoftware.onx.profile.model.ProfileAttributeBlock(Integer.valueOf(updatedBlock.getId()), updatedAttributes);
    }

    @Nonnull
    private ProfileAttribute toProfileAttribute(UpdatedProfileAttribute updatedAttribute, ProfileSectionConfiguration sectionConfig) {
        String attributeName = updatedAttribute.getKey();
        de.justsoftware.onx.profile.model.ProfileAttributeConfiguration attributeConfig = sectionConfig.getAttributes().stream().filter(attribute -> attribute.getName().equals(attributeName)).findFirst().orElse(null);
        if (attributeConfig == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " does not exist.");
        }
        ImmutableList nonEmptyValues = (ImmutableList)updatedAttribute.getValues().stream().filter(value -> !value.isBlank()).collect(ImmutableList.toImmutableList());
        return new ProfileAttribute(attributeName, attributeConfig.getType(), nonEmptyValues);
    }
}

