/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.service;

import com.google.common.collect.ImmutableList;
import de.justsoftware.mobile.api.people.model.PeopleApiProfile;
import de.justsoftware.mobile.api.people.model.PeopleApiProfileSearchResult;
import de.justsoftware.mobile.api.people.model.PeopleApiProfileSearchResults;
import de.justsoftware.onx.container.shared.model.TenantId;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@ParametersAreNonnullByDefault
public class PeopleApiGatewayService {
    private final String _peopleApiUrl;
    private final RestOperations _authorizedRestOperations;

    @Autowired
    public PeopleApiGatewayService(@Value(value="${just-people.api.url}") String peopleApiUrl, @Qualifier(value="mobileApiGatewayRestOperations") RestOperations authorizedRestOperations) {
        this._peopleApiUrl = peopleApiUrl;
        this._authorizedRestOperations = authorizedRestOperations;
    }

    @Nonnull
    private URI profilesUri(TenantId tenantId, @Nullable String query, int offset, int limit) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this._peopleApiUrl + "/profiles"));
        uriBuilder.queryParam("tenantId", new Object[]{tenantId.asString()});
        uriBuilder.queryParam("offset", new Object[]{offset});
        uriBuilder.queryParam("limit", new Object[]{limit});
        if (query != null) {
            uriBuilder.queryParam("query", new Object[]{query});
        }
        return uriBuilder.build().toUri();
    }

    @Nonnull
    public ImmutableList<PeopleApiProfile> getProfiles(TenantId tenantId, @Nullable String query, int offset, int limit) {
        URI uri = this.profilesUri(tenantId, query, offset, limit);
        PeopleApiProfileSearchResults result = (PeopleApiProfileSearchResults)this._authorizedRestOperations.getForObject(uri, PeopleApiProfileSearchResults.class);
        return result == null ? ImmutableList.of() : (ImmutableList)result.getRows().stream().map(PeopleApiProfileSearchResult::getProfile).collect(ImmutableList.toImmutableList());
    }
}

