/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.model;

import com.google.common.collect.ImmutableList;
import de.justsoftware.mobile.api.people.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileSectionType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileSectionConfiguration {
    private final String _key;
    private final ProfileSectionType _type;
    private final boolean _multiple;
    private final ImmutableList<ProfileAttributeConfiguration> _attributes;
    private final ProfileSectionPermissions _allowed;

    public ProfileSectionConfiguration(String key, ProfileSectionType type, boolean multiple, ImmutableList<ProfileAttributeConfiguration> attributes) {
        this._key = key;
        this._type = type;
        this._multiple = multiple;
        this._attributes = attributes;
        boolean mayEdit = attributes.stream().anyMatch(attribute -> attribute.getAllowed().isEdit());
        boolean mayDelete = attributes.stream().noneMatch(attribute -> Boolean.TRUE.equals(attribute.isRequired()));
        this._allowed = new ProfileSectionPermissions(mayEdit, mayDelete);
    }

    @Nonnull
    public String getKey() {
        return this._key;
    }

    @Nonnull
    public ProfileSectionType getType() {
        return this._type;
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    @Nonnull
    public ImmutableList<ProfileAttributeConfiguration> getAttributes() {
        return this._attributes;
    }

    @Nonnull
    public ProfileSectionPermissions getAllowed() {
        return this._allowed;
    }

    public static final class ProfileSectionPermissions {
        final boolean _edit;
        final boolean _delete;

        public ProfileSectionPermissions(boolean mayEdit, boolean delete) {
            this._edit = mayEdit;
            this._delete = delete;
        }

        public boolean isEdit() {
            return this._edit;
        }

        public boolean isDelete() {
            return this._delete;
        }
    }
}

