/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.model;

import de.justsoftware.mobile.api.people.model.Profile;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileDetails
extends Profile {
    private final String _title;
    private final String _firstName;
    private final String _lastName;
    private final String _additionalTitle;
    private final ProfilePermissions _profilePermissions;

    public ProfileDetails(Profile profile, @Nullable String title, String firstName, String lastName, @Nullable String additionalTitle, boolean mayChatWith, boolean mayEditProfile) {
        super(profile.getId(), profile.getName(), profile.getState(), profile.getImageUrl());
        this._title = title;
        this._firstName = firstName;
        this._lastName = lastName;
        this._additionalTitle = additionalTitle;
        this._profilePermissions = new ProfilePermissions(mayChatWith, mayEditProfile);
    }

    @CheckForNull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getFirstName() {
        return this._firstName;
    }

    @Nonnull
    public String getLastName() {
        return this._lastName;
    }

    @CheckForNull
    public String getAdditionalTitle() {
        return this._additionalTitle;
    }

    @Nonnull
    public ProfilePermissions getAllowed() {
        return this._profilePermissions;
    }

    private static final class ProfilePermissions {
        private final boolean _chatWith;
        private final boolean _editProfile;

        public ProfilePermissions(boolean chatWith, boolean editProfile) {
            this._chatWith = chatWith;
            this._editProfile = editProfile;
        }

        public boolean isChatWith() {
            return this._chatWith;
        }

        public boolean isEditProfile() {
            return this._editProfile;
        }
    }
}

