/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.model;

import com.google.common.collect.ImmutableList;
import de.justsoftware.mobile.api.people.model.ProfileSectionConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileConfiguration {
    private final ProfilePermissions _allowed;
    private final ImmutableList<ProfileSectionConfiguration> _sections;

    public ProfileConfiguration(boolean mayEditTitle, boolean mayEditFirstName, boolean mayEditLastName, boolean mayEditAdditionalTitle, boolean mayEditImage, ImmutableList<ProfileSectionConfiguration> sections) {
        this._allowed = new ProfilePermissions(mayEditTitle, mayEditFirstName, mayEditLastName, mayEditAdditionalTitle, mayEditImage);
        this._sections = sections;
    }

    public ProfilePermissions getAllowed() {
        return this._allowed;
    }

    @Nonnull
    public ImmutableList<ProfileSectionConfiguration> getSections() {
        return this._sections;
    }

    public static final class ProfilePermissions {
        private final boolean _editTitle;
        private final boolean _editFirstName;
        private final boolean _editLastName;
        private final boolean _editAdditionalTitle;
        private final boolean _editImage;

        public ProfilePermissions(boolean mayEditTitle, boolean mayEditFirstName, boolean mayEditLastName, boolean mayEditAdditionalTitle, boolean mayEditImage) {
            this._editTitle = mayEditTitle;
            this._editFirstName = mayEditFirstName;
            this._editLastName = mayEditLastName;
            this._editAdditionalTitle = mayEditAdditionalTitle;
            this._editImage = mayEditImage;
        }

        public boolean isEditTitle() {
            return this._editTitle;
        }

        public boolean isEditFirstName() {
            return this._editFirstName;
        }

        public boolean isEditLastName() {
            return this._editLastName;
        }

        public boolean isEditAdditionalTitle() {
            return this._editAdditionalTitle;
        }

        public boolean isEditImage() {
            return this._editImage;
        }
    }
}

