/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.notifications.service;

import de.justsoftware.mobile.api.common.model.ApiGatewayException;
import de.justsoftware.mobile.api.notifications.model.NotificationsCount;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class NotificationsApiGatewayService {
    private final String _notificationApiUrl;
    private final RestOperations _restOperations;

    @Autowired
    public NotificationsApiGatewayService(@Value(value="${just-notification.api.url}") String notificationApiUrl, @Qualifier(value="mobileApiGatewayRestOperations") RestOperations restOperations) {
        this._notificationApiUrl = notificationApiUrl;
        this._restOperations = restOperations;
    }

    @Nonnull
    public ResponseEntity<NotificationsCount> notificationsCount() {
        String url = String.format("%s/notification/count", this._notificationApiUrl);
        return this.sendGet(url, NotificationsCount.class);
    }

    @Nonnull
    private <T> ResponseEntity<T> sendGet(String url, Class<T> type) {
        return NotificationsApiGatewayService.wrapHttpErrors(() -> this._restOperations.getForEntity(url, type, new Object[0]));
    }

    @Nonnull
    private static <R> R wrapHttpErrors(Supplier<R> apiCall) {
        try {
            return apiCall.get();
        }
        catch (HttpStatusCodeException e) {
            throw new ApiGatewayException(e);
        }
    }
}

