/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.legacy.util;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.legacy.model.EventFilter;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Component;

@Component(value="MobileSearchUtil")
@ParametersAreNonnullByDefault
public class SearchUtil {
    @Nonnull
    public SortType getSortType(EventFilter eventFilter) {
        return eventFilter == EventFilter.PAST ? SortType.TIME_DESCENDING : SortType.TIME_ASCENDING;
    }

    @Nonnull
    public ImmutableSet<SubFilter> getSubFilters() {
        return ImmutableSet.of((Object)ArchiveSubFilter.NON_ARCHIVED);
    }

    @Nonnull
    public ImmutableSet<SubFilter> getSubFilters(EventFilter eventFilter) {
        ImmutableSet.Builder subFilters = ImmutableSet.builder();
        subFilters.addAll(this.getSubFilters());
        if (eventFilter == EventFilter.FUTURE) {
            subFilters.add((Object)DateSubFilter.FUTURE);
        }
        if (eventFilter == EventFilter.PAST) {
            subFilters.add((Object)DateSubFilter.PAST);
        }
        return subFilters.build();
    }
}

