/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.legacy.service;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.mobile.api.legacy.model.Entity;
import de.justsoftware.mobile.api.legacy.model.EntityTypeConfig;
import de.justsoftware.mobile.api.legacy.model.EventAttendanceStatus;
import de.justsoftware.mobile.api.legacy.model.EventFilter;
import de.justsoftware.mobile.api.legacy.model.SubscriptionFilter;
import de.justsoftware.mobile.api.legacy.service.LegacyMapper;
import de.justsoftware.mobile.api.legacy.util.SearchUtil;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.business.EntityEventWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowService;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDetailsNotVisibleException;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MobileApiLegacyService")
@ParametersAreNonnullByDefault
public class LegacyService {
    private final LegacyMapper _legacyMapper;
    private final Settings _settings;
    private final EntityTypeAppMappingService _entityTypeAppMappingService;
    private final SearchService _searchService;
    private final SearchUtil _searchUtil;
    private final EntityConfigService _entityConfigService;
    private final EntityDetailsService _entityDetailsService;
    private final EntityEventWorkflowService _entityEventWorkflowService;
    private final EntityMemberWorkflowService _entityMemberWorkflowService;
    private final EntityMemberService _entityMemberService;

    @Autowired
    public LegacyService(LegacyMapper legacyMapper, Settings settings, EntityTypeAppMappingService entityTypeAppMappingService, SearchService searchService, SearchUtil searchUtil, EntityConfigService entityConfigService, EntityDetailsService entityDetailsService, EntityEventWorkflowService entityEventWorkflowService, EntityMemberWorkflowService entityMemberWorkflowService, EntityMemberService entityMemberService) {
        this._legacyMapper = legacyMapper;
        this._settings = settings;
        this._entityTypeAppMappingService = entityTypeAppMappingService;
        this._searchService = searchService;
        this._searchUtil = searchUtil;
        this._entityConfigService = entityConfigService;
        this._entityDetailsService = entityDetailsService;
        this._entityEventWorkflowService = entityEventWorkflowService;
        this._entityMemberWorkflowService = entityMemberWorkflowService;
        this._entityMemberService = entityMemberService;
    }

    @Nonnull
    public ImmutableSet<de.justsoftware.mobile.api.legacy.model.EntityType> getSupportedEntityTypes(String appId) {
        CoreApp app = this.appById(appId);
        ImmutableSet types = this._entityTypeAppMappingService.getEntityTypesForApp(app);
        ImmutableSet supportedTypes = app == CoreApp.SOCIAL ? Sets.intersection((Set)this._settings.getSupportedLegacyEntityTypes(), (Set)types) : types;
        return (ImmutableSet)supportedTypes.stream().map(this._legacyMapper::toEntityType).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public ImmutableList<Entity> getEntities(List<de.justsoftware.mobile.api.legacy.model.EntityType> entityTypes, EventFilter eventFilter, SubscriptionFilter subscriptionFilter, int offset, int limit, AuthorizationContext authContext) {
        ImmutableSet<EntityType> activeEntityTypes = this.activatedEntityTypes(entityTypes);
        if (activeEntityTypes.isEmpty()) {
            return ImmutableList.of();
        }
        boolean allEvents = activeEntityTypes.stream().allMatch(this::isEvent);
        SortType sortType = allEvents ? this._searchUtil.getSortType(eventFilter) : SortType.ALPHABETICAL;
        ImmutableSet<SubFilter> subFilters = allEvents ? this._searchUtil.getSubFilters(eventFilter) : this._searchUtil.getSubFilters();
        ImmutableSet<FilterType> filterTypes = this.filterTypes(activeEntityTypes);
        SearchContextModel searchContext = this.searchContext(subscriptionFilter);
        SearchResult searchResult = this._searchService.search(null, filterTypes, sortType, searchContext, subFilters, (SearchFacetParameters)StaticSearchFacetParameters.NO_FACETS, offset, limit, (SearchAuthorizationCheckContext)authContext);
        return this._legacyMapper.toEntities((SearchResult<FederatedSearchResultEntry>)searchResult, authContext);
    }

    @Nonnull
    public EntityTypeConfig getEntityTypeConfig(de.justsoftware.mobile.api.legacy.model.EntityType entityType) {
        return new EntityTypeConfig(this.isEvent(this._legacyMapper.toLegacyEntityType(entityType)));
    }

    @Nonnull
    public de.justsoftware.mobile.api.legacy.model.EntityDetails getEntityDetails(EntityId id, AuthorizationContext authContext) {
        try {
            EntityDetails legacyEntityDetails = this._entityDetailsService.getDetailsById(id, authContext);
            return this._legacyMapper.toEntityDetails(legacyEntityDetails, authContext);
        }
        catch (EntityDetailsNotVisibleException e) {
            return this._legacyMapper.toFallbackEntityDetails((EntityInfo)e, authContext);
        }
    }

    @Nonnull
    public de.justsoftware.mobile.api.legacy.model.EntityDetails updateEventAttendanceStatus(EntityId id, EventAttendanceStatus newStatus, AuthorizationContext authContext) {
        switch (newStatus) {
            case ATTENDING: {
                this._entityEventWorkflowService.attendEvent(id, (AuthorizationCheckContextWithUserId)authContext);
                break;
            }
            case NOT_ATTENDING: {
                this._entityEventWorkflowService.dontAttendEvent(id, (AuthorizationCheckContextWithUserId)authContext);
                break;
            }
            case MAYBE_ATTENDING: {
                this._entityEventWorkflowService.maybeAttendEvent(id, (AuthorizationCheckContextWithUserId)authContext);
                break;
            }
            case NONE: {
                this._entityEventWorkflowService.leaveEvent(id, (AuthorizationCheckContextWithUserId)authContext);
            }
        }
        return this.getEntityDetails(id, authContext);
    }

    @Nonnull
    public de.justsoftware.mobile.api.legacy.model.EntityDetails updateMembership(EntityId id, boolean joining, AuthorizationContext authContext) {
        boolean hasInvitation;
        EntityMemberWithPerson memberInfo = (EntityMemberWithPerson)this._entityMemberService.getEntityMembersMappedByEntityId(id).get((Object)authContext.getUserId());
        boolean bl = hasInvitation = memberInfo != null && EntityMemberRoles.hasInvitation((Set)memberInfo.getRoles());
        if (hasInvitation && joining) {
            this._entityMemberWorkflowService.acceptInvitation(id, (AuthorizationCheckContextWithUserId)authContext);
        } else if (!hasInvitation && joining) {
            this._entityMemberWorkflowService.joinEntity(id, (AuthorizationCheckContextWithUserId)authContext);
        } else if (hasInvitation) {
            this._entityMemberWorkflowService.rejectInvitationToEntity(id, (AuthorizationCheckContextWithUserId)authContext);
        } else {
            this._entityMemberWorkflowService.leaveEntity(id, authContext.getUserId(), (AuthorizationCheckContextWithUserId)authContext);
        }
        return this.getEntityDetails(id, authContext);
    }

    @CheckForNull
    private SearchContextModel searchContext(SubscriptionFilter subscriptionFilter) {
        return subscriptionFilter == SubscriptionFilter.ALL ? null : SearchContextModel.create((SearchContext)SearchContext.SUBSCRIPTION, null);
    }

    @Nonnull
    private ImmutableSet<EntityType> activatedEntityTypes(List<de.justsoftware.mobile.api.legacy.model.EntityType> entityTypes) {
        return (ImmutableSet)entityTypes.stream().map(this._legacyMapper::toLegacyEntityType).filter(arg_0 -> ((EntityConfigService)this._entityConfigService).entityTypeActivated(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<FilterType> filterTypes(ImmutableSet<EntityType> entityTypes) {
        return (ImmutableSet)entityTypes.stream().map(FilterTypes::getByEntityType).collect(ImmutableSet.toImmutableSet());
    }

    private boolean isEvent(EntityType entityType) {
        return this._entityConfigService.getDurationTimeOption(entityType) != EntityDurationTimeOption.OFF;
    }

    @Nonnull
    private CoreApp appById(String appId) {
        return Arrays.stream(CoreApp.values()).filter(app -> app.getSimpleName().equals(appId)).findAny().orElseThrow(() -> new InvalidIdServiceException("Invalid app ID " + appId));
    }
}

