/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.legacy.model;

import de.justsoftware.mobile.api.legacy.model.EntityEventData;
import de.justsoftware.mobile.api.legacy.model.EntityType;
import de.justsoftware.mobile.api.legacy.model.EventAttendanceStatus;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityId;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Entity {
    private final EntityId _id;
    private final String _name;
    private final EntityType _type;
    private final boolean _subscribed;
    private final boolean _notificationsEnabled;
    private final Date _startDate;
    private final Date _endDate;
    private final String _location;
    private final boolean _isMember;
    private final boolean _hasInvitation;
    private final EventAttendanceStatus _attendanceStatus;
    private final EntityPermissions _allowed;

    public Entity(EntityId id, String name, EntityType type, boolean subscribed, boolean notificationsEnabled, boolean mayJoin, boolean mayLeave, boolean isMember, boolean hasInvitation, @Nullable EntityEventData eventData) {
        this._id = id;
        this._name = name;
        this._type = type;
        this._subscribed = subscribed;
        this._notificationsEnabled = notificationsEnabled;
        this._startDate = eventData == null ? null : Dates.clone((Date)eventData.getStartDate());
        this._endDate = eventData == null ? null : Dates.clone((Date)eventData.getEndDate());
        this._location = eventData == null ? null : eventData.getLocation();
        this._isMember = isMember;
        this._hasInvitation = hasInvitation;
        this._attendanceStatus = eventData == null ? null : eventData.getAttendanceStatus();
        this._allowed = new EntityPermissions(!subscribed, subscribed, !notificationsEnabled, notificationsEnabled, mayJoin, mayLeave, eventData != null && eventData.isMayAttendEvent());
    }

    @Nonnull
    public EntityId getId() {
        return this._id;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public EntityType getType() {
        return this._type;
    }

    public boolean isSubscribed() {
        return this._subscribed;
    }

    public boolean isNotificationsEnabled() {
        return this._notificationsEnabled;
    }

    @CheckForNull
    public Date getStartDate() {
        return Dates.clone((Date)this._startDate);
    }

    @CheckForNull
    public Date getEndDate() {
        return Dates.clone((Date)this._endDate);
    }

    @CheckForNull
    public String getLocation() {
        return this._location;
    }

    @Nonnull
    public EntityPermissions getAllowed() {
        return this._allowed;
    }

    public boolean getIsMember() {
        return this._isMember;
    }

    public boolean isHasInvitation() {
        return this._hasInvitation;
    }

    @CheckForNull
    public EventAttendanceStatus getAttendanceStatus() {
        return this._attendanceStatus;
    }

    static class EntityPermissions {
        private final boolean _subscribe;
        private final boolean _unsubscribe;
        private final boolean _enableNotifications;
        private final boolean _disableNotifications;
        private final boolean _join;
        private final boolean _leave;
        private final boolean _attendEvent;

        EntityPermissions(boolean subscribe, boolean unsubscribe, boolean enableNotifications, boolean disableNotifications, boolean join, boolean leave, boolean attendEvent) {
            this._subscribe = subscribe;
            this._unsubscribe = unsubscribe;
            this._enableNotifications = enableNotifications;
            this._disableNotifications = disableNotifications;
            this._join = join;
            this._leave = leave;
            this._attendEvent = attendEvent;
        }

        public boolean isSubscribe() {
            return this._subscribe;
        }

        public boolean isUnsubscribe() {
            return this._unsubscribe;
        }

        public boolean isEnableNotifications() {
            return this._enableNotifications;
        }

        public boolean isDisableNotifications() {
            return this._disableNotifications;
        }

        public boolean isJoin() {
            return this._join;
        }

        public boolean isLeave() {
            return this._leave;
        }

        public boolean isAttendEvent() {
            return this._attendEvent;
        }
    }
}

