/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.legacy.controller;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.common.JustMobileApiIdCustomEditors;
import de.justsoftware.mobile.api.legacy.model.Entity;
import de.justsoftware.mobile.api.legacy.model.EntityDetails;
import de.justsoftware.mobile.api.legacy.model.EntityType;
import de.justsoftware.mobile.api.legacy.model.EntityTypeConfig;
import de.justsoftware.mobile.api.legacy.model.EventAttendanceStatus;
import de.justsoftware.mobile.api.legacy.model.EventFilter;
import de.justsoftware.mobile.api.legacy.model.SubscriptionFilter;
import de.justsoftware.mobile.api.legacy.service.LegacyService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.container.shared.model.EntityId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/mobile/api/v1/legacy"})
@Api(tags={"Legacy"})
public class LegacyController
extends JustMobileApiIdCustomEditors {
    private final LegacyService _legacyService;

    @Autowired
    public LegacyController(LegacyService legacyService) {
        this._legacyService = legacyService;
    }

    @GetMapping(value={"/types/{appId}"})
    @ApiOperation(value="Retrieve supported legacy entity types for the app with the specified ID.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ImmutableSet<EntityType> getEntityTypes(@AuthorizedContext AuthorizationContext authContext, @PathVariable(value="appId") String appId) {
        return this._legacyService.getSupportedEntityTypes(appId);
    }

    @GetMapping(value={"/types/{entityType}/config"})
    @ApiOperation(value="Retrieve config for an entity type.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public EntityTypeConfig getEntityTypeConfig(@PathVariable(value="entityType") EntityType entityType, @AuthorizedContext AuthorizationContext authContext) {
        return this._legacyService.getEntityTypeConfig(entityType);
    }

    @GetMapping(value={"/entities"})
    @ApiOperation(value="Retrieve legacy entities", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ImmutableList<Entity> getEntities(@RequestParam(value="type") List<EntityType> entityTypes, @RequestParam(value="eventFilter", defaultValue="ALL") EventFilter eventFilter, @RequestParam(value="subscriptionFilter", defaultValue="ALL") SubscriptionFilter subscriptionFilter, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="25") int limit, @AuthorizedContext AuthorizationContext authContext) {
        return this._legacyService.getEntities(entityTypes, eventFilter, subscriptionFilter, offset, limit, authContext);
    }

    @GetMapping(value={"/entities/{id}"})
    @ApiOperation(value="Retrieve entity details.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public EntityDetails getEntityDetails(@PathVariable(value="id") EntityId id, @AuthorizedContext AuthorizationContext authContext) {
        return this._legacyService.getEntityDetails(id, authContext);
    }

    @PutMapping(value={"/entities/{id}/attendance"})
    @ApiOperation(value="Update the attendance status for an event.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public EntityDetails updateEventAttendanceStatus(@PathVariable(value="id") EntityId id, @RequestBody EventAttendanceStatus newStatus, @AuthorizedContext AuthorizationContext authContext) {
        return this._legacyService.updateEventAttendanceStatus(id, newStatus, authContext);
    }

    @PutMapping(value={"/entities/{id}/membership"})
    @ApiOperation(value="Update the membership for an entity.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public EntityDetails updateMembership(@PathVariable(value="id") EntityId id, @RequestBody boolean member, @AuthorizedContext AuthorizationContext authContext) {
        return this._legacyService.updateMembership(id, member, authContext);
    }
}

