/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.feed.service;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.feed.model.Comment;
import de.justsoftware.mobile.api.feed.model.CommentContent;
import de.justsoftware.mobile.api.feed.model.CreatePostData;
import de.justsoftware.mobile.api.feed.model.Feed;
import de.justsoftware.mobile.api.feed.model.Like;
import de.justsoftware.mobile.api.feed.model.PinnedFeed;
import de.justsoftware.mobile.api.feed.model.PollAnswer;
import de.justsoftware.mobile.api.feed.model.Post;
import de.justsoftware.mobile.api.feed.model.UpdatePostData;
import de.justsoftware.mobile.api.feed.service.FeedMapper;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.ListAndCountAndIndex;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.workstream.business.WorkstreamReadService;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.shared.model.AbstractWorkstream;
import de.justsoftware.onx.workstream.shared.model.PinnedWorkstream;
import de.justsoftware.onx.workstream.shared.model.Workstream;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPosting;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingCreateModel;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingEditModel;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import de.justsoftware.polls.PollService;
import de.justsoftware.polls.model.Poll;
import de.justsoftware.polls.model.pollid.PollId;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MobileApiFeedService")
@ParametersAreNonnullByDefault
public class FeedService {
    private final ItemService _itemService;
    private final WorkstreamService _workstreamService;
    private final WorkstreamReadService _workstreamReadService;
    private final CommentsService _commentsService;
    private final LikeService _likeService;
    private final PollService _pollService;
    private final ProfileTeaserService _profileTeaserService;
    private final FeedMapper _feedMapper;
    private final Settings _settings;

    @Autowired
    public FeedService(ItemService itemService, WorkstreamService workstreamService, WorkstreamReadService workstreamReadService, CommentsService commentsService, LikeService likeService, PollService pollService, ProfileTeaserService profileTeaserService, FeedMapper feedMapper, Settings settings) {
        this._itemService = itemService;
        this._workstreamService = workstreamService;
        this._workstreamReadService = workstreamReadService;
        this._commentsService = commentsService;
        this._likeService = likeService;
        this._pollService = pollService;
        this._profileTeaserService = profileTeaserService;
        this._feedMapper = feedMapper;
        this._settings = settings;
    }

    @CheckForNull
    public Feed getFeed(ItemId feedId, @Nullable Date offset, Integer limit, boolean includePinnedPosts, AuthorizationContext authContext) {
        Item item = this._itemService.getById(feedId);
        if (item == null) {
            return null;
        }
        Workstream workstream = this._workstreamService.getWorkstreamForMobile(item, offset, limit.intValue(), includePinnedPosts, (SearchAuthorizationCheckContext)authContext);
        this._workstreamReadService.markRead(feedId, (AuthorizationContextWithUserId)authContext);
        return this._feedMapper.toFeed((AbstractWorkstream)workstream, (Item<? extends ItemId>)item, authContext);
    }

    @CheckForNull
    public PinnedFeed getPinnedFeed(ItemId feedId, @Nullable Date offset, Integer limit, AuthorizationContext authContext) {
        Item item = this._itemService.getById(feedId);
        if (item == null) {
            return null;
        }
        PinnedWorkstream workstream = this._workstreamService.getPinnedWorkstream(item, offset, limit.intValue(), (SearchAuthorizationCheckContext)authContext);
        return this._feedMapper.toPinnedFeed(workstream, (Item<? extends ItemId>)item, authContext);
    }

    @CheckForNull
    public Post getPost(WorkstreamMessageId postId, AuthorizationContext authContext) {
        WorkstreamMessage workstreamMessage = this._workstreamService.getMessage(postId, (AuthorizationCheckContextWithLocale)authContext);
        return workstreamMessage instanceof MicroblogPosting ? this._feedMapper.toPost((MicroblogPosting)workstreamMessage, authContext) : null;
    }

    @CheckForNull
    public Post createPost(ItemId feedId, CreatePostData createPostData, AuthorizationContext authContext) throws IllegalStateException, ValidationException {
        this.checkNotEmpty(createPostData);
        MicroblogPostingCreateModel microblogPostingCreateModel = this._feedMapper.toMicroblogPostingCreateModel(feedId, createPostData);
        WorkstreamMessageId postId = this._workstreamService.postToMicroblog(microblogPostingCreateModel, (AuthorizationCheckContextWithUserId)authContext);
        return this.getPost(postId, authContext);
    }

    @CheckForNull
    public Post updatePost(WorkstreamMessageId postId, UpdatePostData updatePostData, AuthorizationContext authContext) throws IllegalStateException, ValidationException {
        this.checkNotEmpty(updatePostData);
        MicroblogPostingEditModel microblogPostingEditModel = this._feedMapper.toMicroblogPostingEditModel(postId, updatePostData);
        this._workstreamService.editMicroblogPosting(microblogPostingEditModel, (AuthorizationCheckContextWithUserId)authContext);
        PollId removedPoll = updatePostData.getRemovedPoll();
        if (removedPoll != null) {
            this.deletePoll(postId, removedPoll, authContext);
        }
        return this.getPost(postId, authContext);
    }

    public void deletePost(WorkstreamMessageId postId, AuthorizationContext authContext) {
        this._workstreamService.deleteMessage(postId, (AuthorizationCheckContextWithUserId)authContext);
    }

    @CheckForNull
    public Post voteInPoll(WorkstreamMessageId postId, PollId pollId, ImmutableSet<UUID> votedAnswerIds, AuthorizationContext authContext) {
        if (!this._settings.isQuickPollsEnabled()) {
            return this.getPost(postId, authContext);
        }
        de.justsoftware.mobile.api.feed.model.Poll poll = this.getPoll(pollId, authContext);
        if (poll == null) {
            return null;
        }
        ProfileId currentUserId = authContext.getUserId().asProfileId();
        this.checkValidPollAnswers(poll, votedAnswerIds);
        this._pollService.vote(currentUserId, pollId, this._feedMapper.toPollAnswerIds((Set<UUID>)votedAnswerIds));
        return this.getPost(postId, authContext);
    }

    @CheckForNull
    public ImmutableSet<Profile> getPollAnswerVoters(PollId pollId, UUID answerId, AuthorizationContext authContext) {
        if (!this._settings.isQuickPollsEnabled()) {
            return null;
        }
        de.justsoftware.mobile.api.feed.model.Poll poll = this.getPoll(pollId, authContext);
        if (poll == null) {
            return null;
        }
        PollAnswer answer = this.getPollAnswer(poll, answerId);
        return answer != null ? this.getProfiles(answer.getVotes(), authContext) : null;
    }

    @Nonnull
    public ImmutableList<Comment> getComments(WorkstreamMessageId parentId, AuthorizationContext authContext) {
        boolean newestFirst = false;
        int max = Integer.MAX_VALUE;
        ListAndCount comments = this._commentsService.getCommentsByParentId((ItemId)parentId, Integer.MAX_VALUE, false, (AuthorizationCheckContextWithLocale)authContext);
        return this._feedMapper.toComments((ListAndCount<GenericComment>)comments, authContext);
    }

    @Nonnull
    public Comment createComment(WorkstreamMessageId parentId, CommentContent commentContent, AuthorizationContext authContext) {
        this.checkNotEmpty(commentContent);
        CommentId id = this._commentsService.addComment((String)Preconditions.checkNotNull((Object)commentContent.getText()), null, (ItemId)parentId, commentContent.getQuillDelta(), (AuthorizationCheckContextWithUserId)authContext);
        return this.getComment(id, authContext);
    }

    @Nonnull
    public Comment updateComment(CommentId id, CommentContent update, AuthorizationContext authContext) {
        this.checkNotEmpty(update);
        this._commentsService.editComment(id, (String)Preconditions.checkNotNull((Object)update.getText()), update.getQuillDelta(), (AuthorizationCheckContextWithUserId)authContext);
        return this.getComment(id, authContext);
    }

    public void deleteComment(CommentId id, AuthorizationContext authContext) {
        this._commentsService.deleteComment(id, (AuthorizationCheckContextWithUserId)authContext);
    }

    @Nonnull
    public Like updateLike(ItemId itemId, boolean like, AuthorizationContext authContext) {
        this._likeService.setLikeAndSubscription(itemId, like, (AuthorizationCheckContextWithUserId)authContext);
        ImmutableMap likeStatus = this._likeService.getLikes((Iterable)ImmutableSet.of((Object)itemId), (AuthorizationCheckContextWithUserId)authContext);
        return this._feedMapper.toLike((LikeStatus)likeStatus.get((Object)itemId));
    }

    @Nonnull
    public ImmutableSet<Profile> getLikers(ItemId itemId, AuthorizationContext authContext) {
        ListAndCountAndIndex likers = this._likeService.getAllLikers(itemId, 0, 1000, (AuthorizationCheckContextWithLocale)authContext);
        return this._feedMapper.toProfiles((Collection<PersonTeaserModel>)likers);
    }

    @Nonnull
    private ImmutableSet<Profile> getProfiles(ImmutableSet<ProfileId> ids, AuthorizationContext authContext) {
        ImmutableCollection teasers = this._profileTeaserService.getPersonTeasersByIds(this._feedMapper.toPersonIds(ids), (AuthorizationCheckContextWithLocale)authContext).values();
        return this._feedMapper.toProfiles((Collection<PersonTeaserModel>)teasers);
    }

    @Nonnull
    private Comment getComment(CommentId id, AuthorizationContext authContext) {
        GenericComment newComment = this._commentsService.getComment(id, (AuthorizationCheckContextWithLocale)authContext);
        if (newComment == null) {
            throw new IllegalStateException("Comment with id " + id + " does not exist.");
        }
        return this._feedMapper.toComment(newComment, authContext);
    }

    @CheckForNull
    private de.justsoftware.mobile.api.feed.model.Poll getPoll(PollId pollId, AuthorizationContext authContext) {
        ProfileId currentUserId = authContext.getUserId().asProfileId();
        return this._pollService.findPoll(pollId).map(poll -> {
            authContext.check(poll.getParentId(), (Action)StaticAction.WORKSTREAM_READ);
            return this._feedMapper.toPoll((Poll)poll, currentUserId);
        }).orElse(null);
    }

    @CheckForNull
    private PollAnswer getPollAnswer(de.justsoftware.mobile.api.feed.model.Poll poll, UUID answerId) {
        return poll.getAnswers().stream().filter(answer -> answer.getId().equals(answerId)).findFirst().orElse(null);
    }

    private void deletePoll(WorkstreamMessageId postId, PollId pollId, AuthorizationContext authContext) {
        if (!this._settings.isQuickPollsEnabled()) {
            return;
        }
        authContext.check((ItemId)postId, (Action)StaticAction.WORKSTREAM_DELETE);
        this._workstreamService.detachAttachment(postId, (ItemId)pollId, (ServerEventCollector)new CollectingServerEventCollector());
        this._pollService.deletePoll(pollId);
    }

    private void checkValidPollAnswers(de.justsoftware.mobile.api.feed.model.Poll poll, ImmutableSet<UUID> answerIds) throws IllegalStateException {
        boolean tooManyAnswers;
        ImmutableSet availableAnswerIds = (ImmutableSet)poll.getAnswers().stream().map(PollAnswer::getId).collect(ImmutableSet.toImmutableSet());
        boolean bl = tooManyAnswers = !poll.isAllowMultipleVotes() && answerIds.size() > 1;
        if (!availableAnswerIds.containsAll(answerIds) || tooManyAnswers) {
            throw new IllegalStateException("Invalid answers.");
        }
    }

    private void checkNotEmpty(CreatePostData postData) throws IllegalStateException {
        this.checkNotEmpty(postData.getText(), postData.getQuillDelta());
    }

    private void checkNotEmpty(UpdatePostData postData) throws IllegalStateException {
        this.checkNotEmpty(postData.getText(), postData.getQuillDelta());
    }

    private void checkNotEmpty(CommentContent commentData) throws IllegalStateException {
        this.checkNotEmpty(commentData.getText(), commentData.getQuillDelta());
    }

    private void checkNotEmpty(@Nullable String text, @Nullable String quillDelta) throws IllegalStateException {
        if (StringUtil.isEmpty((String)text) || StringUtil.isEmpty((String)quillDelta)) {
            throw new IllegalStateException("Text and quillDelta required to create a microblog post or comment.");
        }
    }
}

