/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.feed.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.feed.model.Comment;
import de.justsoftware.mobile.api.feed.model.CreatePostData;
import de.justsoftware.mobile.api.feed.model.Feed;
import de.justsoftware.mobile.api.feed.model.Like;
import de.justsoftware.mobile.api.feed.model.PinnedFeed;
import de.justsoftware.mobile.api.feed.model.PollAnswer;
import de.justsoftware.mobile.api.feed.model.Post;
import de.justsoftware.mobile.api.feed.model.TempFile;
import de.justsoftware.mobile.api.feed.model.UpdatePostData;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.mobile.api.people.service.PeopleMapper;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.document.business.DocumentService;
import de.justsoftware.onx.document.server.model.DocumentAccessTokenId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveTempId;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.thumbor.business.ThumborService;
import de.justsoftware.onx.workstream.shared.model.AbstractWorkstream;
import de.justsoftware.onx.workstream.shared.model.PinnedWorkstream;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.attachments.DriveDocumentAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.PollAttachment;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPosting;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingCreateModel;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingEditModel;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import de.justsoftware.polls.model.Poll;
import de.justsoftware.polls.model.PollAnswerId;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="MobileApiFeedMapper")
@ParametersAreNonnullByDefault
public class FeedMapper {
    private final DocumentService _documentService;
    private final ThumborService _thumborService;
    private final LikeService _likeService;
    private final CommentsService _commentsService;
    private final PeopleMapper _peopleMapper;
    private final String _documentControllerUrl;

    @Autowired
    public FeedMapper(DocumentService documentService, ThumborService thumborService, LikeService likeService, CommentsService commentsService, PeopleMapper peopleMapper, @Value(value="${api.root}/v1/document") String documentControllerUrl) {
        this._documentService = documentService;
        this._thumborService = thumborService;
        this._likeService = likeService;
        this._commentsService = commentsService;
        this._peopleMapper = peopleMapper;
        this._documentControllerUrl = documentControllerUrl;
    }

    @Nonnull
    public Feed toFeed(AbstractWorkstream workstream, Item<? extends ItemId> item, AuthorizationContext authContext) {
        ImmutableSet msgIds = (ImmutableSet)workstream.getMessages().stream().map(Identifiables.toId()).collect(ImmutableSet.toImmutableSet());
        ImmutableMap likes = this._likeService.getLikes((Iterable)msgIds, (AuthorizationCheckContextWithUserId)authContext);
        ImmutableMap commentCounts = this._commentsService.getCommentsCounts((Set)msgIds);
        ProfileId currentUserId = authContext.getUserId().asProfileId();
        ImmutableList posts = (ImmutableList)workstream.getMessages().stream().filter(message -> message instanceof MicroblogPosting).map(arg_0 -> this.lambda$toFeed$1((Map)likes, commentCounts, currentUserId, arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableSet permissions = authContext.may(item, ImmutableSet.of((Object)StaticAction.WORKSTREAM_POST, (Object)StaticAction.WORKSTREAM_PIN));
        return new Feed(item.getId(), (ImmutableList<Post>)posts, (ImmutableSet<Action>)permissions);
    }

    @Nonnull
    public PinnedFeed toPinnedFeed(PinnedWorkstream workstream, Item<? extends ItemId> item, AuthorizationContext authContext) {
        Feed feed = this.toFeed((AbstractWorkstream)workstream, item, authContext);
        return new PinnedFeed(feed, this.toDateTime(workstream.getHideDate()));
    }

    @Nonnull
    public Post toPost(MicroblogPosting post, LikeStatus likeStatus, Integer commentCount, ProfileId currentUserId) {
        ImmutableList attachments = (ImmutableList)post.getAttachments().stream().filter(attachment -> attachment instanceof DriveDocumentAttachment).map(this::toAttachment).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        de.justsoftware.mobile.api.feed.model.Poll poll = post.getAttachments().stream().filter(attachment -> attachment instanceof PollAttachment).findFirst().map(pollAttachment -> this.toPoll(((PollAttachment)pollAttachment).getPoll(), currentUserId)).orElse(null);
        return new Post((ItemId)post.getId(), post.getTitle(), post.getText(), post.getQuillDelta(), (ImmutableList<de.justsoftware.mobile.api.feed.model.Attachment>)attachments, post.getOriginId(), post.getOriginName(), this.toDateTime(post.getPublishedAt()), this._peopleMapper.toProfile(post.getAuthor()), this.toDateTime(post.getPinDate()), this.toLike(likeStatus), commentCount, poll, (ImmutableSet<Action>)post.getMay());
    }

    @Nonnull
    public Post toPost(MicroblogPosting post, AuthorizationContext authContext) {
        ImmutableSet ids = ImmutableSet.of((Object)post.getId());
        ImmutableMap likes = this._likeService.getLikes((Iterable)ids, (AuthorizationCheckContextWithUserId)authContext);
        ImmutableMap commentCounts = this._commentsService.getCommentsCounts((Set)ids);
        ProfileId currentUserId = authContext.getUserId().asProfileId();
        return this.toPost(post, likes.getOrDefault(post.getId(), LikeStatus.EMPTY), (Integer)commentCounts.getOrDefault((Object)post.getId(), (Object)0), currentUserId);
    }

    @Nonnull
    public de.justsoftware.mobile.api.feed.model.Poll toPoll(Poll poll, ProfileId currentUserId) {
        ImmutableList answers = (ImmutableList)poll.getAnswers().stream().map(answer -> this.toPollAnswer((de.justsoftware.polls.model.PollAnswer)answer, currentUserId)).collect(ImmutableList.toImmutableList());
        return new de.justsoftware.mobile.api.feed.model.Poll(poll.getId(), poll.getQuestion(), poll.isAllowMultipleAnswers(), (ImmutableList<PollAnswer>)answers);
    }

    @Nonnull
    public PollAnswer toPollAnswer(de.justsoftware.polls.model.PollAnswer answer, ProfileId currentUserId) {
        boolean voted = answer.getVotes().contains((Object)currentUserId);
        return new PollAnswer(answer.getId().getId(), answer.getText(), (ImmutableSet<ProfileId>)ImmutableSet.copyOf((Collection)answer.getVotes()), voted);
    }

    @Nonnull
    public ImmutableSet<PollAnswerId> toPollAnswerIds(Set<UUID> answerIds) {
        return (ImmutableSet)answerIds.stream().map(PollAnswerId::new).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public MicroblogPostingCreateModel toMicroblogPostingCreateModel(ItemId feedId, CreatePostData createPostData) {
        ImmutableList attachments = (ImmutableList)createPostData.getAttachments().stream().map(this::toDriveDocumentAttachment).collect(ImmutableList.toImmutableList());
        return new MicroblogPostingCreateModel(feedId, this.safeString(createPostData.getTitle()), this.safeString(createPostData.getText()), this.safeString(createPostData.getQuillDelta()), null, false, attachments, null, null);
    }

    @Nonnull
    public MicroblogPostingEditModel toMicroblogPostingEditModel(WorkstreamMessageId postId, UpdatePostData updatePostData) {
        ImmutableList newAttachments = (ImmutableList)updatePostData.getFilesToAdd().stream().map(this::toDriveDocumentAttachment).collect(ImmutableList.toImmutableList());
        return new MicroblogPostingEditModel(postId, this.safeString(updatePostData.getTitle()), this.safeString(updatePostData.getText()), this.safeString(updatePostData.getQuillDelta()), null, null, newAttachments, updatePostData.getFilesToDelete(), null, null);
    }

    @Nonnull
    public ImmutableList<Comment> toComments(ListAndCount<GenericComment> comments, AuthorizationContext authContext) {
        ImmutableSet commentIds = (ImmutableSet)comments.stream().map(Identifiable::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableMap likes = this._likeService.getLikes((Iterable)commentIds, (AuthorizationCheckContextWithUserId)authContext);
        return (ImmutableList)comments.stream().map(arg_0 -> this.lambda$toComments$6((Map)likes, arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public Comment toComment(GenericComment comment, AuthorizationContext authContext) {
        ImmutableMap likes = this._likeService.getLikes((Iterable)ImmutableSet.of((Object)comment.getId()), (AuthorizationCheckContextWithUserId)authContext);
        return this.toComment(comment, (LikeStatus)likes.get((Object)comment.getId()));
    }

    @Nonnull
    public Like toLike(@Nullable LikeStatus likeStatus) {
        return likeStatus == null ? new Like(false, 0, (ImmutableSet<Action>)ImmutableSet.of()) : new Like(likeStatus.isDoILike(), likeStatus.getLikeCount(), (ImmutableSet<Action>)likeStatus.getPermissions());
    }

    @Nonnull
    public ImmutableSet<PersonId> toPersonIds(ImmutableSet<ProfileId> profileIds) {
        return (ImmutableSet)profileIds.stream().map(ProfileId::asPersonId).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public ImmutableSet<Profile> toProfiles(Collection<PersonTeaserModel> teasers) {
        return (ImmutableSet)teasers.stream().map(this._peopleMapper::toProfile).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private Comment toComment(GenericComment comment, @Nullable LikeStatus like) {
        return new Comment(comment.getId(), comment.getParentId(), comment.getText(), comment.getEditorModel(), this._peopleMapper.toProfileNullable(comment.getAuthor()), new DateTime((Object)comment.getPostedAt()), this.toDateTime(comment.getEditedAt()), this.toLike(like), (ImmutableSet<Action>)comment.getPermissions());
    }

    @Nonnull
    private String safeString(@Nullable String unsafeValue) {
        return Optional.ofNullable(unsafeValue).orElse("");
    }

    @Nonnull
    private DriveDocumentAttachment toDriveDocumentAttachment(TempFile tempFile) {
        return new DriveDocumentAttachment((DriveTempId)Preconditions.checkNotNull((Object)tempFile.getId()), (String)Preconditions.checkNotNull((Object)tempFile.getFileName()), (String)Preconditions.checkNotNull((Object)tempFile.getMimeType()));
    }

    @CheckForNull
    private de.justsoftware.mobile.api.feed.model.Attachment toAttachment(Attachment attachment) {
        if (!(attachment instanceof DriveDocumentAttachment)) {
            return null;
        }
        DriveDocumentAttachment driveDocumentAttachment = (DriveDocumentAttachment)attachment;
        DriveDocumentId documentId = (DriveDocumentId)Preconditions.checkNotNull((Object)driveDocumentAttachment.getId());
        DocumentAccessTokenId accessToken = this._documentService.createDocumentAccessToken((ItemId)documentId);
        if (accessToken == null) {
            return null;
        }
        String mimeType = driveDocumentAttachment.getMimeType();
        boolean thumbnailAvailable = mimeType != null && this._thumborService.thumbnailAvailable(mimeType);
        String previewUrl = thumbnailAvailable ? this.getDocumentThumbnailUrl((ItemId)documentId, accessToken) : null;
        return new de.justsoftware.mobile.api.feed.model.Attachment((ItemId)documentId, driveDocumentAttachment.getName(), driveDocumentAttachment.getFileSize(), mimeType, driveDocumentAttachment.getLikeCount(), driveDocumentAttachment.getCommentCount(), previewUrl);
    }

    @Nonnull
    private String getDocumentThumbnailUrl(ItemId documentId, DocumentAccessTokenId accessToken) {
        return UriComponentsBuilder.fromPath((String)this._documentControllerUrl).pathSegment(new String[]{"unauthorized", documentId.asString(), "thumbnail"}).queryParam("token", new Object[]{accessToken}).build().toString();
    }

    @CheckForNull
    private DateTime toDateTime(@Nullable Date date) {
        return date == null ? null : new DateTime((Object)date);
    }

    private /* synthetic */ Comment lambda$toComments$6(Map likes, GenericComment comment) {
        return this.toComment(comment, (LikeStatus)likes.get(comment.getId()));
    }

    private /* synthetic */ Post lambda$toFeed$1(Map likes, ImmutableMap commentCounts, ProfileId currentUserId, WorkstreamMessage message) {
        return this.toPost((MicroblogPosting)message, likes.getOrDefault(message.getId(), LikeStatus.EMPTY), (Integer)commentCounts.getOrDefault(message.getId(), (Object)0), currentUserId);
    }
}

