/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.feed.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.feed.model.Attachment;
import de.justsoftware.mobile.api.feed.model.Like;
import de.justsoftware.mobile.api.feed.model.Poll;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class Post {
    private final ItemId _id;
    private final String _title;
    private final String _text;
    private final String _quillDelta;
    private final ImmutableList<Attachment> _attachments;
    private final ItemId _originId;
    private final String _originName;
    private final DateTime _publishedDate;
    private final Profile _author;
    private final DateTime _pinDate;
    private final Like _like;
    private final int _numberOfComments;
    private final Poll _poll;
    private final PostPermissions _allowed;

    public Post(ItemId id, @Nullable String title, String text, String quillDelta, ImmutableList<Attachment> attachments, ItemId originId, @Nullable String originName, @Nullable DateTime publishedDate, Profile author, @Nullable DateTime pinDate, Like like, int numberOfComments, @Nullable Poll poll, @Nullable ImmutableSet<Action> may) {
        this._id = id;
        this._title = title;
        this._text = text;
        this._quillDelta = quillDelta;
        this._attachments = attachments;
        this._originId = originId;
        this._originName = originName;
        this._publishedDate = publishedDate;
        this._author = author;
        this._pinDate = pinDate;
        this._like = like;
        this._numberOfComments = numberOfComments;
        this._poll = poll;
        this._allowed = new PostPermissions(this.mayComment(may), this.mayDelete(may), this.mayEdit(may), this.mayPin(may));
    }

    @Nonnull
    public ItemId getId() {
        return this._id;
    }

    @CheckForNull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getText() {
        return this._text;
    }

    @Nonnull
    public String getQuillDelta() {
        return this._quillDelta;
    }

    @Nonnull
    public ImmutableList<Attachment> getAttachments() {
        return this._attachments;
    }

    @Nonnull
    public ItemId getOriginId() {
        return this._originId;
    }

    @CheckForNull
    public String getOriginName() {
        return this._originName;
    }

    @CheckForNull
    public DateTime getPublishedDate() {
        return this._publishedDate;
    }

    @Nonnull
    public Profile getAuthor() {
        return this._author;
    }

    @CheckForNull
    public DateTime getPinDate() {
        return this._pinDate;
    }

    @Nonnull
    public Like getLike() {
        return this._like;
    }

    public int getNumberOfComments() {
        return this._numberOfComments;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public Poll getPoll() {
        return this._poll;
    }

    @Nonnull
    public PostPermissions getAllowed() {
        return this._allowed;
    }

    private boolean mayComment(@Nullable ImmutableSet<Action> may) {
        return may != null && may.contains((Object)StaticAction.COMMENT_CREATE);
    }

    private boolean mayDelete(@Nullable ImmutableSet<Action> may) {
        return may != null && may.contains((Object)StaticAction.WORKSTREAM_DELETE);
    }

    private boolean mayEdit(@Nullable ImmutableSet<Action> may) {
        return may != null && may.contains((Object)StaticAction.WORKSTREAM_EDIT);
    }

    private boolean mayPin(@Nullable ImmutableSet<Action> may) {
        return may != null && may.contains((Object)StaticAction.WORKSTREAM_PIN);
    }

    private static final class PostPermissions {
        private final boolean _comment;
        private final boolean _delete;
        private final boolean _edit;
        private final boolean _pin;

        private PostPermissions(boolean comment, boolean delete, boolean edit, boolean pin) {
            this._comment = comment;
            this._delete = delete;
            this._edit = edit;
            this._pin = pin;
        }

        public boolean isComment() {
            return this._comment;
        }

        public boolean isDelete() {
            return this._delete;
        }

        public boolean isEdit() {
            return this._edit;
        }

        public boolean isPin() {
            return this._pin;
        }
    }
}

