/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.feed.model;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Like {
    private final boolean _iLike;
    private final int _likeCount;
    private final LikePermissions _allowed;

    public Like(boolean iLike, int likeCount, ImmutableSet<Action> permissions) {
        this._iLike = iLike;
        this._likeCount = likeCount;
        this._allowed = new LikePermissions(!iLike && permissions.contains((Object)StaticItemAction.LIKE_SUBSCRIBE), iLike && permissions.contains((Object)StaticItemAction.UNLIKE_UNSUBSCRIBE));
    }

    public boolean isILike() {
        return this._iLike;
    }

    public int getLikeCount() {
        return this._likeCount;
    }

    @Nonnull
    public LikePermissions getAllowed() {
        return this._allowed;
    }

    private static final class LikePermissions {
        private final boolean _like;
        private final boolean _unlike;

        private LikePermissions(boolean like, boolean unlike) {
            this._like = like;
            this._unlike = unlike;
        }

        public boolean isLike() {
            return this._like;
        }

        public boolean isUnlike() {
            return this._unlike;
        }
    }
}

