/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.feed.model;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.feed.model.Like;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class Comment {
    final CommentId _id;
    final ItemId _parentId;
    final CommentContent _content;
    final Profile _author;
    final DateTime _postDate;
    final DateTime _editDate;
    final Like _like;
    final CommentPermissions _allowed;

    public Comment(CommentId id, ItemId parentId, String text, @Nullable String quillDelta, @Nullable Profile author, DateTime postDate, @Nullable DateTime editDate, Like like, ImmutableSet<Action> may) {
        this._id = id;
        this._parentId = parentId;
        this._content = new CommentContent(text, quillDelta);
        this._author = author;
        this._postDate = postDate;
        this._editDate = editDate;
        this._like = like;
        this._allowed = new CommentPermissions(may.contains((Object)StaticAction.COMMENT_EDIT), may.contains((Object)StaticAction.COMMENT_DELETE));
    }

    @Nonnull
    public CommentId getId() {
        return this._id;
    }

    @Nonnull
    public ItemId getParentId() {
        return this._parentId;
    }

    @Nonnull
    public CommentContent getContent() {
        return this._content;
    }

    @CheckForNull
    public Profile getAuthor() {
        return this._author;
    }

    @Nonnull
    public DateTime getPostDate() {
        return this._postDate;
    }

    @CheckForNull
    public DateTime getEditDate() {
        return this._editDate;
    }

    @Nonnull
    public Like getLike() {
        return this._like;
    }

    @Nonnull
    public CommentPermissions getAllowed() {
        return this._allowed;
    }

    @ParametersAreNonnullByDefault
    private static final class CommentContent {
        private final String _text;
        private final String _delta;

        private CommentContent(String text, @Nullable String quillDelta) {
            this._text = text;
            this._delta = quillDelta;
        }

        @Nonnull
        public String getText() {
            return this._text;
        }

        @CheckForNull
        public String getDelta() {
            return this._delta;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class CommentPermissions {
        private final boolean _edit;
        private final boolean _delete;

        private CommentPermissions(boolean edit, boolean delete) {
            this._edit = edit;
            this._delete = delete;
        }

        public boolean isEdit() {
            return this._edit;
        }

        public boolean isDelete() {
            return this._delete;
        }
    }
}

