/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.feed.controller;

import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.common.JustMobileApiIdCustomEditors;
import de.justsoftware.mobile.api.common.utils.Responses;
import de.justsoftware.mobile.api.feed.model.Comment;
import de.justsoftware.mobile.api.feed.model.CommentContent;
import de.justsoftware.mobile.api.feed.model.CreatePostData;
import de.justsoftware.mobile.api.feed.model.Feed;
import de.justsoftware.mobile.api.feed.model.Like;
import de.justsoftware.mobile.api.feed.model.PinnedFeed;
import de.justsoftware.mobile.api.feed.model.PollVotes;
import de.justsoftware.mobile.api.feed.model.Post;
import de.justsoftware.mobile.api.feed.model.UpdatePostData;
import de.justsoftware.mobile.api.feed.service.FeedService;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.polls.model.pollid.PollId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/mobile/api/v1/feed"})
@Api(tags={"Feed"})
public class FeedController
extends JustMobileApiIdCustomEditors {
    private final FeedService _feedService;

    @Autowired
    public FeedController(FeedService feedService) {
        this._feedService = feedService;
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="Returns the feed for the given id.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Feed> getFeed(@PathVariable(value="id") ItemId feedId, @Nullable @RequestParam(value="offset", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Date offset, @RequestParam(value="limit", defaultValue="10") Integer limit, @RequestParam(value="includePinnedPosts", defaultValue="false") boolean includePinnedPosts, @AuthorizedContext AuthorizationContext authContext) {
        Feed feed = this._feedService.getFeed(feedId, offset, limit, includePinnedPosts, authContext);
        return Responses.okOrNotFound(feed);
    }

    @GetMapping(value={"/{id}/pinned"})
    @ApiOperation(value="Returns the feed for the given id.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<PinnedFeed> getPinnedFeed(@PathVariable(value="id") ItemId feedId, @Nullable @RequestParam(value="offset", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Date offset, @RequestParam(value="limit", defaultValue="10") Integer limit, @AuthorizedContext AuthorizationContext authContext) {
        PinnedFeed pinnedFeed = this._feedService.getPinnedFeed(feedId, offset, limit, authContext);
        return Responses.okOrNotFound(pinnedFeed);
    }

    @GetMapping(value={"/posts/{id}"})
    @ApiOperation(value="Returns a post.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Post> getPost(@PathVariable(value="id") WorkstreamMessageId postId, @AuthorizedContext AuthorizationContext authContext) {
        Post post = this._feedService.getPost(postId, authContext);
        return Responses.okOrNotFound(post);
    }

    @PostMapping(path={"/{id}"}, headers={"content-type=application/json"}, consumes={"application/json"})
    @ApiOperation(value="Creates a post.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Post> createPost(@PathVariable(value="id") ItemId feedId, @RequestBody CreatePostData createPostData, @AuthorizedContext AuthorizationContext authContext) throws ValidationException {
        Post post = this._feedService.createPost(feedId, createPostData, authContext);
        return Responses.okOrNotFound(post);
    }

    @PutMapping(path={"/posts/{id}"}, headers={"content-type=application/json"}, consumes={"application/json"})
    @ApiOperation(value="Updates a post.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Post> updatePost(@PathVariable(value="id") WorkstreamMessageId postId, @RequestBody UpdatePostData updatePostData, @AuthorizedContext AuthorizationContext authContext) throws ValidationException {
        Post post = this._feedService.updatePost(postId, updatePostData, authContext);
        return Responses.okOrNotFound(post);
    }

    @DeleteMapping(value={"/posts/{id}"})
    @ApiOperation(value="Deletes a post.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Void> deletePost(@PathVariable(value="id") WorkstreamMessageId postId, @AuthorizedContext AuthorizationContext authContext) {
        this._feedService.deletePost(postId, authContext);
        return Responses.ok();
    }

    @PutMapping(path={"/posts/{postId}/polls/{pollId}/vote"}, headers={"content-type=application/json"}, consumes={"application/json"})
    @ApiOperation(value="Update quick poll votes.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Post> voteInPoll(@PathVariable(value="postId") WorkstreamMessageId postId, @PathVariable(value="pollId") PollId pollId, @RequestBody PollVotes votes, @AuthorizedContext AuthorizationContext authContext) {
        Post post = this._feedService.voteInPoll(postId, pollId, votes.getAnswerIds(), authContext);
        return Responses.okOrNotFound(post);
    }

    @GetMapping(value={"/posts/{postId}/polls/{pollId}/answers/{answerId}/voters"})
    @ApiOperation(value="Retrieve profiles voting for the given answer.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ImmutableSet<Profile>> getPollAnswerVoters(@PathVariable(value="postId") WorkstreamMessageId postId, @PathVariable(value="pollId") PollId pollId, @PathVariable(value="answerId") UUID answerId, @AuthorizedContext AuthorizationContext authContext) {
        ImmutableSet<Profile> voters = this._feedService.getPollAnswerVoters(pollId, answerId, authContext);
        return Responses.okOrNotFound(voters);
    }

    @GetMapping(value={"/posts/{id}/comments"})
    @ApiOperation(value="Retrieve comments of a post.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ImmutableList<Comment>> getComments(@PathVariable(value="id") WorkstreamMessageId parentId, @AuthorizedContext AuthorizationContext authContext) {
        ImmutableList<Comment> comments = this._feedService.getComments(parentId, authContext);
        return Responses.okOrNotFound(comments);
    }

    @PostMapping(value={"/posts/{id}/comments"})
    @ApiOperation(value="Create a comment.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Comment> createComment(@PathVariable(value="id") WorkstreamMessageId parentId, @RequestBody CommentContent createCommentData, @AuthorizedContext AuthorizationContext authContext) {
        Comment comment = this._feedService.createComment(parentId, createCommentData, authContext);
        return Responses.okOrNotFound(comment);
    }

    @PutMapping(value={"/comments/{id}"})
    @ApiOperation(value="Update a comment.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Comment> updateComment(@PathVariable(value="id") CommentId id, @RequestBody CommentContent update, @AuthorizedContext AuthorizationContext authContext) {
        Comment comment = this._feedService.updateComment(id, update, authContext);
        return Responses.okOrNotFound(comment);
    }

    @DeleteMapping(value={"/comments/{id}"})
    @ApiOperation(value="Update a comment.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Void> deleteComment(@PathVariable(value="id") CommentId id, @AuthorizedContext AuthorizationContext authContext) {
        this._feedService.deleteComment(id, authContext);
        return Responses.ok();
    }

    @PutMapping(value={"/likes/{itemId}"})
    @ApiOperation(value="Updates the like on an item.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Like> updateLike(@PathVariable(value="itemId") ItemId itemId, @RequestBody boolean like, @AuthorizedContext AuthorizationContext authContext) {
        Like updatedLike = this._feedService.updateLike(itemId, like, authContext);
        return Responses.okOrNotFound(updatedLike);
    }

    @GetMapping(value={"/likes/{itemId}/likers"})
    @ApiOperation(value="Retrieve profiles liking the given item.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ImmutableSet<Profile>> getLikers(@PathVariable(value="itemId") ItemId itemId, @AuthorizedContext AuthorizationContext authContext) {
        ImmutableSet<Profile> likers = this._feedService.getLikers(itemId, authContext);
        return Responses.okOrNotFound(likers);
    }
}

