/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.common.utils;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

@ParametersAreNonnullByDefault
public final class Responses {
    @Nonnull
    public static <T> ResponseEntity<T> okOrNotFound(@Nullable T data) {
        return ResponseEntity.of(Optional.ofNullable(data));
    }

    @Nonnull
    public static <T> ResponseEntity<T> ok() {
        return new ResponseEntity(HttpStatus.OK);
    }

    @Nonnull
    public static <T> ResponseEntity<T> badRequest() {
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @Nonnull
    public static <T> ResponseEntity<T> notFound() {
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Nonnull
    public static <T> ResponseEntity<T> internalServerError() {
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

